% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{n1.get}
\alias{n1.get}
\title{Find smallest value of n1 that achieves target power}
\usage{
n1.get(data, n0, beta, delta, alpha, type = 1, plt = FALSE)
}
\arguments{
\item{data}{a matrix with column names beta, p0.vals, n0, n1 and 481^2 rows
(See details)}

\item{n0}{scalar value of n0 between 20 and 500 inclusive}

\item{beta}{scalar target for power}

\item{delta}{value of clinically relevant difference}

\item{alpha}{value of nominal size of test}

\item{type}{type of minimum solution (See details)}

\item{plt}{if true produce diagnostic plots}
}
\value{
a single scalar value of n1. An integer indicates a solution was
found in the database. A non-integer indicates an extrapolated solution. An
Inf value indicates no extrapolated solution was found.
}
\description{
Function calculates minimum value of n1 that achieves power beta. If there
is no solution less than 500, it models observed powers as a function of n1
and then extrapolates. It returns an infinite value if the power is
unattainable.
}
\details{
This function is called by n1.get.vector and will likely never be run by the
user.

The data matrix will be a subset of one of the 85 main databases. Supplying
alpha and delta loads the appropriate database and selecting a value of p0
further subsets this data base. The resulting matrix will have 4 columns and
481^2 rows corresponding to all values of n0 and n1 from 20 to 500 inclusive
and is suitable for input into n1.get.

If type=1, the smallest value N1 of n1 so that power > beta is returned. If
type=2, the smallest value N1 of n1 so that power > beta for all n1>=N1 is
returned.
}
\examples{

# Load toy version of power library for alpha=0.025, delta=0.20.
# Alternatively, load the full library using fetch.data(alpha=0.025,delta=0.20)
rdata_file = system.file('files', 'LIB.a025.d20.Rdata', package = 'exact.n')
load(rdata_file)
data=LIB.a025.d20[LIB.a025.d20[,2]==0.5,] # select subset with p0=.5
# For given value of n0, what minimum value of n1 ensures power at least 0.7?
n1.get(data, n0=70, beta=.7, delta=.2, alpha=0.025,
       type = 1, plt = TRUE) # Explicit solution 63 found in data base
n1.get(data, n0=50, beta=.7, delta=.2, alpha=0.025,
       type = 1, plt = TRUE) # Approximate solution 131 extrapolated from toy data base
# You can check the accuracy of this extrapolated result:
# POWER(n0=50,n1=131,alpha=0.025,delta=0.2,p0=0.5,type="elr")
# The minimum power at p0=0.5 is 0.699, slightly less than 0.7.
# With the full library n1.get returns the correct answer of n1=136.
n1.get(data, n0=30, beta=.7, delta=.2, alpha=0.025,
       type = 1, plt = TRUE) # Extrapolated solution is infinite


}
\references{
C.J. Lloyd (2022) Exact samples sizes for clinical trials subject to
size and power constraints. Preprint. \doi{10.13140/RG.2.2.11828.94085}
}
\author{
Chris J. Lloyd
}
