% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographic_fns.R
\name{lifespan}
\alias{lifespan}
\title{Expected lifespan}
\usage{
lifespan(Umat, all_ages = TRUE)
}
\arguments{
\item{Umat}{The survival components of the population projection matrix}

\item{all_ages}{User specifies whether the function should return the
expected lifespan remaining for all ages (all_ages="T") or only the
expected lifespan at birth (all_ages="F").}
}
\value{
The expected lifespan is either a vector (if all_ages="T") or a
single number for the expected lifespan of a newly born individual (if
all_ages="F"). Expected lifespan is given in the same units as the
projection time step. If the projection interval is two weeks, the lifespan
will be the number of two-week intervals that an individual is expected to
survive. You may wish to convert to a standard time step, like days or
years.
}
\description{
The expected lifespan vector is calculated by multiplying a column
of ones by the fundamental matrix. The fundamental matrix, generally
referred to as \strong{N}, contains the expected number of timesteps that an
individual will spend in each age, stage, or size class of the matrix, given
their current state.
}
\details{
The expected lifespan vector contains the expected lifespan remaining for
an individual in each age, stage, or size class of the population. If the
user requests only the expected lifespan from birth, then only the first
entry of the expected lifespan vector is returned.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
U1<- A1
U1[1,3]<- 0
# the upper right corner represents adult fertility in this model. U1, the
# survival matrix, contains all the transitions *except* for fertility.
eta<- lifespan(U1, all_ages=TRUE)
eta_1<- lifespan(U1, all_ages=FALSE) # eta_1 should match the first entry of eta
}
