% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_LRA.R
\name{LRA}
\alias{LRA}
\title{Latent Rank Analysis}
\usage{
LRA(
  U,
  nrank = 2,
  na = NULL,
  Z = NULL,
  w = NULL,
  method = "GTM",
  mic = FALSE,
  maxiter = 100,
  BIC.check = FALSE,
  seed = NULL
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{nrank}{number of latent rank}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{method}{Specify either "SOM" or "GTM".
SOM refers to the estimation method using Self-Organizing Mapping,
which is suitable when the data size is small. However, as the sample
size increases, it takes time to execute.
GTM is a batch learning type of SOM, equivalent to applying a gentle
filter to LCA (Shojima, 2022).}

\item{mic}{Monotonic increasing IRP option. The default is FALSE.}

\item{maxiter}{Maximum number of iterations. default is 100.}

\item{BIC.check}{During estimation with SOM, this parameter determines
whether to use the change in BIC as the convergence criterion.
By default, it is FALSE and iteration continues until the maximum
number of iterations is reached. If set to TRUE, iteration
continues until the overall change in BIC falls below a negligible
amount, or until the iteration count reaches ten times the maximum
number of iterations.}

\item{seed}{random seed for SOM.If not specified, a value derived from
the original data will be automatically assigned.}
}
\value{
\describe{
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{Nclass}{number of classes you set}
\item{TRP}{Test Reference Profile matrix. The TRP is the column sum vector of estimated class reference matrix,
\eqn{\hat{\Pi}_c}}
\item{LCD}{Latent Class Distribution table.see also \link{plot.exametrika}}
\item{CMD}{Class Membership Distribution table. see also \link{plot.exametrika}}
\item{Students}{Class Membership Profile matrix.The s-th row vector of \eqn{\hat{M}_c}, \eqn{\hat{m}_c}, is the
class membership profile of Student s, namely the posterior probability distribution representing the student's
belonging to the respective latent classes. It also includes the rank with the maximum estimated membership probability,
as well as the rank-up odds and rank-down odds.}
\item{IRP}{Item Reference Profile matrix.The IRP of item j is the j-th row vector in the class reference matrix,
\eqn{\hat{\pi}_c}}
\item{IRPIndex}{The IRP information includes the item location parameters B and Beta,
the slope parameters A and Alpha, and the monotonicity indices C and Gamma.}
\item{ItemFitIndices}{Fit index for each item.See also \link{ItemFit}}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
}
}
\description{
A function for estimating LRA by SOM/GTM
}
\examples{
\donttest{
# Fit a Latent Rank Analysis model with 6 ranks to the sample dataset
result.LRA <- LRA(J15S500, nrank = 6)

# Display the first few rows of student rank membership profiles
# This shows posterior probabilities of students belonging to each rank
head(result.LRA$Students)

# Plot Item Reference Profiles (IRP) for items 1-6 in a 2x3 grid
# Shows the probability of correct response for each rank
plot(result.LRA, type = "IRP", items = 1:6, nc = 2, nr = 3)

# Plot Rank Membership Profiles (RMP) for students 1-9 in a 3x3 grid
# Shows the posterior probability distribution of rank membership for each student
plot(result.LRA, type = "RMP", students = 1:9, nc = 3, nr = 3)

# Plot Test Reference Profile (TRP)
# Shows the column sum vector of estimated rank reference matrix
plot(result.LRA, type = "TRP")

# Plot Latent Rank Distribution (LRD)
# Shows the distribution of students across different ranks
plot(result.LRA, type = "LRD")
}

}
