% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{TetrachoricCorrelationMatrix}
\alias{TetrachoricCorrelationMatrix}
\title{Tetrachoric Correlation Matrix}
\usage{
TetrachoricCorrelationMatrix(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
A matrix of tetrachoric correlations with exametrika class.
Each element (i,j) represents the tetrachoric correlation between items i and j.
The matrix is symmetric with ones on the diagonal.
}
\description{
Calculates the matrix of tetrachoric correlations between all pairs of items.
Tetrachoric Correlation is superior to the phi coefficient as a measure of the
relation of an item pair. This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
\donttest{
# example code
TetrachoricCorrelationMatrix(J15S500)
}
}
