% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_plot.R
\name{expected_plot}
\alias{expected_plot}
\title{Plot Expected Counts}
\usage{
expected_plot(
  expected,
  title = "",
  start = NULL,
  end = NULL,
  ylim = NULL,
  weekly = FALSE,
  color = "#3366FF",
  alpha = 0.5
)
}
\arguments{
\item{expected}{The output from `compute_expected`}

\item{title}{A title to add to plot}

\item{start}{First day to show}

\item{end}{Last day to show}

\item{ylim}{A vector with two numbers that determines the kimits for the y-axis}

\item{weekly}{Logical that determines if data should be summarized into weekly counts}

\item{color}{Color for the expected curve}

\item{alpha}{alpha blending for points}
}
\value{
A ggplot object containing a plot of the original counts and the 
estimated expected values.
}
\description{
Check if expected counts fit data
}
\examples{
data(new_jersey_counts)
exclude_dates <- as.Date("2012-10-29") + 0:180
e <- compute_expected(new_jersey_counts, exclude = exclude_dates, weekday.effect = TRUE)

library(ggplot2)
expected_plot(e, start = as.Date("2012-09-01"), end = as.Date("2013-09-01"))

}
