\name{tricontour}
\alias{tricontour}
\alias{tricontour.inla.mesh}
\alias{tricontour.matrix}
\alias{tricontour.list}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Calculate contour curves on a triangulation
}
\description{
  Calculates contour curves on a triangulation
}
\usage{
tricontour(x, z, nlevels = 10,
           levels = pretty(range(z, na.rm = TRUE), nlevels),
           ...)
\method{tricontour}{inla.mesh}(x, z, nlevels = 10,
           levels = pretty(range(z, na.rm = TRUE), nlevels),
           ...)
\method{tricontour}{matrix}(x, z, nlevels = 10,
           levels = pretty(range(z, na.rm = TRUE), nlevels),
           loc,
           ...)
\method{tricontour}{list}(x, z, nlevels = 10,
           levels = pretty(range(z, na.rm = TRUE), nlevels),
           loc,
           type=c("+", "-"), tol=1e-7,
           ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
    An object generated by a call to
    \code{inla.mesh.2d} or
    \code{inla.mesh.create},
    a triangle-vertex index matrix, or a list of triangulation
    information, \code{list(loc, graph=list(tv))}.
}
\item{z}{a vector containing the values to be contoured (\code{NA}s are
  allowed).}
\item{nlevels}{number of contour levels desired if and only if
          \code{levels} is not supplied.  }
\item{levels}{numeric vector of levels at which to calculate contour lines.
}
\item{loc}{coordinate matrix, to be supplied when \code{x} is given as a
  triangle-vertex index matrix only.
}
\item{type}{\code{"+"} or \code{"-"}, indicating positive or negative
  association. For \code{+}, the generated contours enclose regions
  where \eqn{u_1 \leq z < u_2}, for \code{-} the regions fulfil \eqn{u_1
  < z \leq u_2}.}
\item{tol}{
tolerance for determining if the value at a vertex lies on a level.
}
%%\item{output}{The format of the generated output.  Implemented options
%%are \code{"sp"} (default) and \code{"inla.mesh.segment"} (requires the
%%INLA package).
%%}
\item{...}{
  Additional arguments passed to the other methods.
}
}

\value{
  A list:
  \item{loc}{A coordinate matrix}
  \item{idx}{Contour segment indexs, as a 2-column matrix, each row
    indexing a single segment}
  \item{grp}{A vector of group labels.  Each segment has a label, in
    \code{1,...,nlevels*2+1}, where even labels indicate interior
    on-level contour segments, and odd labels indicate boundary segments
  between levels.}
}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Finn Lindgren
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%%}
\examples{
\donttest{
if (require.nowarnings("INLA")) {
 #Generate mesh and SPDE model
  n.lattice = 20 #increase for more interesting, but slower, examples
  x=seq(from=0,to=10,length.out=n.lattice)
  lattice=inla.mesh.lattice(x=x,y=x)
  mesh=inla.mesh.create(lattice=lattice, extend=FALSE, refine=FALSE)
  spde <- inla.spde2.matern(mesh, alpha=2)

  #Generate an artificial sample
  sigma2.e = 0.01
  n.obs=1000
  obs.loc = cbind(runif(n.obs)*diff(range(x))+min(x),
                  runif(n.obs)*diff(range(x))+min(x))
  Q = inla.spde2.precision(spde, theta=c(log(sqrt(0.5)), log(sqrt(1))))
  x = inla.qsample(Q=Q)
  A = inla.spde.make.A(mesh=mesh,loc=obs.loc)
  Y = as.vector(A \%*\% x + rnorm(n.obs)*sqrt(sigma2.e))

  ## Calculate posterior
  Q.post = (Q + (t(A)\%*\%A)/sigma2.e)
  mu.post = as.vector(solve(Q.post,(t(A)\%*\%Y)/sigma2.e))
              
  ## Calculate continuous contours
  tric = tricontour(mesh, z=mu.post, levels=as.vector(quantile(x,c(0.25,0.75))))
}
}
}
