% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_uk.R
\name{choose_uk}
\alias{choose_uk}
\title{Threshold \eqn{u} and runs parameter \eqn{K} diagnostic for the \eqn{K}-gaps
estimator}
\usage{
choose_uk(data, u, k = 1)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{u, k}{Numeric vectors.  \code{u} is a vector of
extreme value thresholds applied to data.  \code{k} is a vector of values
of the run parameter \eqn{K}, as defined in Suveges and Davison (2010).
See \code{\link{kgaps}} for more details.}
}
\value{
An object (a list) of class \code{c("choose_uk", "exdex")}
  containing
  \item{imt }{an object of class \code{c("kgaps_imt", "exdex")} returned
    from \code{\link{kgaps_imt}}.}
  \item{theta }{a \code{length(u)} by \code{length(k)} matrix.
    Element (i,j) of \code{theta} contains an object (a list) of class
    \code{c("kgaps", "exdex")}, a result of a call
    \code{kgaps(data, u[j], k[i])} to \code{\link{kgaps}}.}
}
\description{
Creates data for a plot to aid the choice of the threshold and
run parameter \eqn{K} for the \eqn{K}-gaps estimator (see
\code{\link{kgaps}}).  \code{\link{plot.choose_uk}} creates the plot.
}
\details{
For each combination of threshold in \code{u} and \eqn{K}
  in \code{k} the functions \code{\link{kgaps}} and \code{\link{kgaps_imt}}
  are called in order to estimate \eqn{\theta} and to perform the
  information matrix test of Suveges and Davison (2010).
}
\examples{
### S&P 500 index

# Multiple thresholds and run parameters
u <- quantile(sp500, probs = seq(0.1, 0.9, by = 0.1))
imt_theta <- choose_uk(sp500, u = u, k = 1:5)
plot(imt_theta)
plot(imt_theta, uprob = TRUE)
plot(imt_theta, y = "theta")

# One run parameter K, many thresholds u
u <- quantile(sp500, probs = seq(0.1, 0.9, by = 0.1))
imt_theta <- choose_uk(sp500, u = u, k = 1)
plot(imt_theta)
plot(imt_theta, y = "theta")

# One threshold u, many run parameters K
u <- quantile(sp500, probs = 0.9)
imt_theta <- choose_uk(sp500, u = u, k = 1:5)
plot(imt_theta)
plot(imt_theta, y = "theta")

### Newlyn sea surges

u <- quantile(newlyn, probs = seq(0.1, 0.9, by = 0.1))
imt_theta <- choose_uk(newlyn, u = u, k = 1:5)
plot(imt_theta, uprob = TRUE)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{https://doi.org/10.1214/09-AOAS292}
}
\seealso{
\code{\link{kgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{kgaps_imt}} for the information matrix test under the
  \eqn{K}-gaps model

\code{\link{plot.choose_uk}} to produce the diagnostic plot.
}
