% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_functions.R
\name{print.expertsurv}
\alias{print.expertsurv}
\title{Print a summary of the survival model(s) fitted by \code{fit.models}}
\usage{
\method{print}{expertsurv}(x, mod = 1, ...)
}
\arguments{
\item{x}{the \code{expertsurv} object (the output of the call to
\code{fit.models})}

\item{mod}{is the index of the model. Default value is 1, but the user can
choose which model fit to visualise, if the call to fit.models has a vector
argument for distr (so many models are fitted & stored in the same object)}

\item{\dots}{additional options, including: \code{digits} = number of
significant digits to be shown in the summary table (default = 6)
\code{original} = a flag to say whether the \emph{original} table
from either \code{flexsurv} or \code{rstan/JAGS} should be printed}
}
\value{
Printed message (no object returned) providing estimates of the survival models.
}
\description{
Prints the summary table for the model(s) fitted, with the estimate of the
parameters - ported from \code{survHE}.
}
\examples{
require("dplyr")
param_expert_example1 <- list()
param_expert_example1[[1]] <- data.frame(dist = c("norm","t"),
                                         wi = c(0.5,0.5), # Ensure Weights sum to 1
                                       param1 = c(0.1,0.12),
                                      param2 = c(0.15,0.5),
                                       param3 = c(NA,3))
timepoint_expert <- 14
data2 <- data \%>\% rename(status = censored) \%>\% mutate(time2 = ifelse(time > 10, 10, time),
                                                       status2 = ifelse(time> 10, 0, status))
mle = example1 <- fit.models.expert(formula=Surv(time2,status2)~1,data=data2,
                   distr=c("wph", "gomp"),
                   method="mle",
                   pool_type = "log pool",
                   opinion_type = "survival",
                   times_expert = timepoint_expert,
                   param_expert = param_expert_example1)
print(mle)
}
\references{
\insertRef{Baio.2020}{expertsurv}
}
\author{
Gianluca Baio
}
\keyword{Parametric}
\keyword{models}
\keyword{survival}
