% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_functions.R
\name{fit.models.expert}
\alias{fit.models.expert}
\title{Fitting Parametric Survival models with Expert Opinion}
\usage{
fit.models.expert(
  formula = NULL,
  data,
  distr = NULL,
  method = "hmc",
  expert_type = "survival",
  param_expert = NULL,
  ...
)
}
\arguments{
\item{formula}{As per \code{fit.models} in \code{survHE}}

\item{data}{As per \code{fit.models} in \code{survHE}}

\item{distr}{As per \code{fit.models} in \code{survHE}. Note Generalized F model is not available for method = "hmc" nor Royston-Parmar available with opinion on the mean survival.}

\item{method}{As per \code{fit.models} in \code{survHE}. (except for the inla method). It should be noted that a few of the models are fit using JAGS, however, for consistency we still use "hmc".}

\item{expert_type}{Either "survival", which indicates expert opinion on the survival function or "mean" (actually anything that does not contain "survival") which represents a belief on difference in survival.}

\item{param_expert}{A list containing a dataframe for each timepoint (if applicable). Each dataframe should have columns with the following names and each row representing an expert:
\itemize{
\item \strong{dist}: Names of the distribution assigned to each expert which may be "norm", "t", "lnorm", "gamma", "beta".
\item \strong{wi}: Weight of the expert, must sum to 1.
\item \strong{param1}: First parameter of the distribution (e.g. mean for norm distribution). Parameters as per \code{SHELF} package.
\item \strong{param2}: Second parameter of the distribution.
\item \strong{param3}: Third parameter of the distribution (NA expect for degrees of freedom for t distribution)
}}

\item{...}{Other arguments may be required depending on the example. See \href{https://github.com/Philip-Cooney/expertsurv/blob/master/README.md}{README} for details.}
}
\value{
An object of class \code{expertsurv} which contains the parameters of the models estimated with expert opinion.
}
\description{
Implementation of survival models with expert opinion on the survival probabilities or expected difference in survival.
Function is equivalent to the \code{fit.models} in \code{survHE} except for the inclusion of the "expert_type" and "param_expert" arguments.
Worked examples can be found in the \href{https://github.com/Philip-Cooney/expertsurv/blob/master/README.md}{README} file.
Note that the default method is "hmc", however, the user may use "mle"  (method "inla" is not included).
}
\examples{
require("dplyr")
#Expert Opinion as a normal distribution centered on 0.1 with sd 0.005
param_expert_example1 <- list()
param_expert_example1[[1]] <- data.frame(dist = c("norm"),
                                         wi = c(1), # Ensure Weights sum to 1
                                         param1 = c(0.1),
                                         param2 = c(0.05),
                                        param3 = c(NA))
timepoint_expert <- 14 # Expert opinion at t = 14

data2 <- data \%>\% rename(status = censored) \%>\% mutate(time2 = ifelse(time > 10, 10, time),
status2 = ifelse(time> 10, 0, status))

example1  <- fit.models.expert(formula=Surv(time2,status2)~1,data=data2,
                              distr=c("wei", "gomp"),
                              method="mle",
                              opinion_type = "survival",
                              times_expert = timepoint_expert, 
                              param_expert = param_expert_example1)
                              
plot(example1, add.km = TRUE, t = seq(0:20)) #Plot Survival
model.fit.plot(example1, type = "aic")  #Plot AIC 

                              
}
\keyword{models}
