% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.plot_expirest_osle}
\alias{plot.plot_expirest_osle}
\title{Plot illustrating the shelf life estimation (osle)}
\usage{
\method{plot}{plot_expirest_osle}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{plot_expirest_osle}} returned by
the \code{\link{plot_expirest_osle}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[base]{formatC}()} function.}
}
\value{
The \sQuote{\code{plot_expirest_osle}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{plot()} for objects of class
\sQuote{\code{plot_expirest_osle}}.
}
\details{
The element \code{Graph} of the \sQuote{\code{plot_expirest_osle}}
object that is returned by the function \code{\link{plot_expirest_osle}()}
is an object of class \sQuote{\code{ggplot}}, generated by the function
\code{\link[ggplot2]{ggplot}()} from the \sQuote{\code{ggplot2}} package.
Thus, the corresponding \code{plot} method is used for plotting. Arguments
to the \code{\link[ggplot2]{ggplot}()} function can be passed via the
\code{...} parameter.
}
\examples{
# Performing an "ordinary shelf life estimation" (osle)
res1 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3,
                srch_range = c(0, 500), sf_option = "loose")

# The 'expirest_osle' object can be passed on to the plot_expirest_osle()
# function. This function does not produce any output but returns a
# 'plot_expirest_osle' object.
\dontrun{
  gg1 <- plot_expirest_osle(
    model = res1, response_vbl_unit = "\%", x_range = NULL, y_range = c(93, 105),
    mtbs = "verified", plot_option = "full", ci_app = "line")
  gg2 <- plot(gg1)

  # The plot() function returns the 'plot_expirest_osle' object invisibly.
  class(gg1)
  class(gg2)
}
}
\seealso{
\code{\link{expirest_osle}}, \code{\link{plot_expirest_osle}},
\code{\link[ggplot2]{ggplot}()}, \code{\link[utils]{methods}}.
}
