% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2office.R
\name{table2office}
\alias{table2office}
\alias{table2doc}
\alias{table2ppt}
\alias{table2ppt}
\alias{table2doc}
\title{Export statistical output to a table in Microsoft Office / LibreOffice format}
\usage{
table2office(x = NULL, file = "Rtable", type = c("PPT", "DOC"),
  append = FALSE, digits = 2, digitspvals = 2, trim.pval = TRUE,
  width = NULL, height = NULL, offx = 1, offy = 1,
  font = ifelse(Sys.info()["sysname"] == "Windows", "Arial",
  "Helvetica")[[1]], pointsize = 12, add.rownames = FALSE)

table2ppt(...)

table2doc(...)
}
\arguments{
\item{x}{given R stats object to export; if set to \code{NULL} the output of the 
previous R command will be exported.}

\item{file}{name of output file. The .pptx or .docx extension is added automatically.}

\item{type}{desired output type - \code{"PPT"} for PowerPoint and \code{"DOC"} for Word.}

\item{append}{logical value - if \code{TRUE} and \code{type="PPT"} or \code{"DOC"} it will
append the table to the given file, where file can also be a given corporate.  If 
\code{append=FALSE} any existing file will be overwritten.}

\item{digits}{number of significant digits to show for all columns except
for the column with p values.}

\item{digitspvals}{number of significant digits to show for columns with p
values.}

\item{trim.pval}{a logical indicating if the p-values for which the significant digit is lower 
than the desired rounding digit (given by \code{digitspvals}) should be trimmed as 
\code{paste0("<", 10^-ndigitspvals)} (eg \code{'<0.01'}) otherwise they are rounded at 
\code{ndigitspvals} digits.}

\item{width}{desired width of table in inches. If the given width exceeds the page or slide 
width, the table width becomes the page/slide width.}

\item{height}{desired height of table in inches. If the given height exceeds the page or slide 
height, the table height becomes the page/slide height.}

\item{offx}{x offset in inches to specify horizontal location of table (only for \code{type=="PPT"}).}

\item{offy}{y offset in inches to specify vertical location of table (only for \code{type=="PPT"}).}

\item{font}{desired font to use for output table; defaults to \code{"Arial"} on Windows
systems and to \code{"Helvetica"} on other systems.}

\item{pointsize}{desired font point size.}

\item{add.rownames}{logical specifying whether or not to add row names.}

\item{\dots}{Further arguments to be passed to \code{table2office}.}
}
\value{
\code{\link[flextable]{flextable}} object
}
\description{
Export currently showing R stats object or stats object obj to a Microsoft
Office / LibreOffice table
}
\details{
Columns corresponding to degrees of freedom (with header "Df" or "df")
are always given as integers. Objects that can be exported with \code{\link{table2office}} are 
all those supported by \code{\link[xtable]{xtable}} and \code{\link[broom]{tidy}}. The function will
first use \code{\link[xtable]{xtable}} to format the data. If the data class is not supported by 
\code{\link[xtable]{xtable}} the function will then use \code{\link[broom]{tidy}}. 
The data classes suported by \code{\link[xtable]{xtable}} are: 
\itemize{
   \item \code{anova} 
   \item \code{aov} 
   \item \code{aovlist} 
   \item \code{data.frame} 
   \item \code{glm} 
   \item \code{gmsar} 
   \item \code{lagImpact} 
   \item \code{lm} 
   \item \code{matrix} 
   \item \code{prcomp} 
   \item \code{sarlm} 
   \item \code{sarlm.pred} 
   \item \code{spautolm} 
   \item \code{sphet} 
   \item \code{splm} 
   \item \code{stsls} 
   \item \code{summary.aov} 
   \item \code{summary.aovlist} 
   \item \code{summary.glm} 
   \item \code{summary.gmsar} 
   \item \code{summary.lm} 
   \item \code{summary.prcomp} 
   \item \code{summary.sarlm} 
   \item \code{summary.spautolm} 
   \item \code{summary.sphet} 
   \item \code{summary.splm} 
   \item \code{summary.stsls} 
   \item \code{table} 
   \item \code{ts} 
   \item \code{zoo}
   } 
The data classes suported by \code{\link[broom]{tidy}} are: 
\itemize{
   \item \code{aareg} 
   \item \code{acf} 
   \item \code{Arima} 
   \item \code{betareg} 
   \item \code{biglm} 
   \item \code{binDesign} 
   \item \code{binWidth} 
   \item \code{brmsfit} 
   \item \code{btergm} 
   \item \code{cch} 
   \item \code{character} 
   \item \code{cld} 
   \item \code{coeftest} 
   \item \code{confint.glht} 
   \item \code{cv.glmnet} 
   \item \code{default} 
   \item \code{density} 
   \item \code{dgCMatrix} 
   \item \code{dgTMatrix} 
   \item \code{dist} 
   \item \code{emmGrid} 
   \item \code{ergm} 
   \item \code{felm} 
   \item \code{fitdistr} 
   \item \code{ftable} 
   \item \code{gam} 
   \item \code{Gam} 
   \item \code{gamlss} 
   \item \code{geeglm} 
   \item \code{glht} 
   \item \code{glmnet} 
   \item \code{glmRob} 
   \item \code{gmm} 
   \item \code{htest} 
   \item \code{ivreg} 
   \item \code{kappa} 
   \item \code{kde} 
   \item \code{kmeans} 
   \item \code{Line} 
   \item \code{Lines} 
   \item \code{list} 
   \item \code{lme} 
   \item \code{lmodel2} 
   \item \code{lmRob} 
   \item \code{logical} 
   \item \code{lsmobj} 
   \item \code{manova} 
   \item \code{map} 
   \item \code{Mclust} 
   \item \code{merMod} 
   \item \code{mle2} 
   \item \code{muhaz} 
   \item \code{multinom} 
   \item \code{nlrq} 
   \item \code{nls} 
   \item \code{NULL} 
   \item \code{numeric} 
   \item \code{orcutt} 
   \item \code{pairwise.htest} 
   \item \code{plm} 
   \item \code{poLCA} 
   \item \code{Polygon} 
   \item \code{Polygons} 
   \item \code{power.htest} 
   \item \code{pyears} 
   \item \code{rcorr} 
   \item \code{ref.grid}
   \item \code{ridgelm} 
   \item \code{rjags} 
   \item \code{roc} 
   \item \code{rowwise_df} 
   \item \code{rq} 
   \item \code{rqs} 
   \item \code{sparseMatrix} 
   \item \code{SpatialLinesDataFrame} 
   \item \code{SpatialPolygons} 
   \item \code{SpatialPolygonsDataFrame} 
   \item \code{spec} 
   \item \code{speedlm} 
   \item \code{stanfit} 
   \item \code{stanreg} 
   \item \code{summary.glht} 
   \item \code{summaryDefault} 
   \item \code{survdiff} 
   \item \code{survexp} 
   \item \code{survfit} 
   \item \code{survreg} 
   \item \code{tbl_df} 
   \item \code{TukeyHSD}
   }
}
\section{Functions}{
\itemize{
\item \code{table2ppt}: Export statistical output to a table in a Microsoft Office PowerPoint/ LibreOffice Impress presentation

\item \code{table2doc}: Export statistical output to a table in a Microsoft Office Word/ LibreOffice Writer document
}}

\examples{
# Create a file name
filen <- tempfile(pattern = "table_aov") # or 
# filen <- paste("YOUR_DIR/table_aov")

# Generate ANOVA output
fit=aov(yield ~ block + N * P + K, data = npk) # 'npk' dataset from base 'datasets'

# Save ANOVA table as a PPT
### Option 1: pass output as object
x=summary(fit)
table2ppt(x=x,file=filen, digits = 1, digitspvals = 3)
### Option 2: get output from console 
summary(fit)
table2ppt(x=x,file=filen, width=5, font="Times New Roman", pointsize=14, 
          digits=4, digitspvals=1, append=TRUE) # append table to previous slide

# Save ANOVA table as a DOC file
table2doc(x=x,file=filen, digits = 1, digitspvals = 3)
summary(fit)
table2doc(file=filen, width=3.5, font="Times New Roman", pointsize=14, 
          digits=4, digitspvals=1, append=TRUE) # append table at end of document
}
\seealso{
\code{\link{table2tex}}, \code{\link{table2html}}, \code{\link{table2spreadsheet}}
}
\author{
Tom Wenseleers, Christophe Vanderaa
}
