% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/megaGen.R
\name{megaGen}
\alias{megaGen}
\title{Extract megadiverse genera from POWO}
\usage{
megaGen(family, thld = 500, verbose = TRUE, save = FALSE, dir, filename)
}
\arguments{
\item{family}{Either one family name or a vector of multiple families that
is present in POWO.}

\item{thld}{A defined threshold of species number for a genus to be
considered megadiverse. The default value is 500 based on Frodin (2004) in
Taxon.}

\item{verbose}{Logical, if \code{FALSE}, the search results will not be
printed in the console in full.}

\item{save}{Logical, if \code{FALSE}, the searched results will not be saved
on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_megaGen} and the searched results
will be saved within a subfolder named by the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
Table in .csv format.
}
\description{
Produces a CSV file listing all mega-diverse genera for
any angiosperm family at
\href{https://powo.science.kew.org/}{Plants of the World Online (POWO)} based on
a provided numeric value as the threshold to be considered mega-diverse.
Frodin (2004) in Taxon suggests 500 species as the threshold.
}
\examples{
\donttest{

library(expowo)

megaGen(family = "Cyperaceae",
        thld = 500,
        verbose = TRUE,
        save = FALSE,
        dir = "results_megaGen/",
        filename = "Cyperaceae_big_genera")
}

}
\seealso{
\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
