% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_labels.R
\name{write_labels}
\alias{read_labelled_csv}
\alias{write_labelled_csv}
\alias{write_labelled_spss}
\alias{write_labels}
\alias{write_labels_spss}
\title{Write data with labels to file in R code or in SPSS syntax.}
\usage{
write_labels(x, filename, fileEncoding = "")

read_labelled_csv(filename, fileEncoding = "", ...)

write_labelled_csv(x, filename, fileEncoding = "", ...)

write_labelled_spss(x, filename, fileEncoding = "", ...)

write_labels_spss(x, filename)
}
\arguments{
\item{x}{data.frame to be written/data.frame whose labels to be written}

\item{filename}{the name of the file which the data are to be read from/write to.}

\item{fileEncoding}{character string: if non-empty declares the encoding to
be used on a file (not a connection) so the character data can be
re-encoded as they are written. See \link[base]{file}.}

\item{...}{additional arguments for \link[utils]{read.table}/\link[utils]{write.table}}
}
\value{
Functions for writing invisibly return NULL. Functions for reading
  return labelled data.frame.
}
\description{
\code{write_labelled_*} functions write data in the CSV format and file with 
R code/SPSS syntax for labelling data.  SPSS syntax also contains code for 
reading data in SPSS. \code{write_labelled_*} doesn't save rownames of
data.frame. \code{write_labels_*} functions write R code/SPSS syntax for
labelling data. It allows to extract labels from *.sav files that come
without accompanying syntax. \code{read_labelled_csv} reads data file in CSV
format and apply labels from accompanying file with R code.
}
\examples{
\dontrun{
data(mtcars)
mtcars = modify(mtcars,{
                var_lab(mpg) = "Miles/(US) gallon"
                var_lab(cyl) = "Number of cylinders"
                var_lab(disp) = "Displacement (cu.in.)"
                var_lab(hp) = "Gross horsepower"
                var_lab(drat) = "Rear axle ratio"
                var_lab(wt) = "Weight (lb/1000)"
                var_lab(qsec) = "1/4 mile time"
                var_lab(vs) = "Engine"
                val_lab(vs) = c("V-engine" = 0, 
                                "Straight engine" = 1) 
                var_lab(am) = "Transmission"
                val_lab(am) = c(automatic = 0, 
                                manual=1)
                var_lab(gear) = "Number of forward gears"
                var_lab(carb) = "Number of carburetors"
})

# to R code
# rownames are not preserved
write_labelled_csv(mtcars, "mtcars.csv")
new_mtcars = read_labelled_csv("mtcars.csv")

# to SPSS syntax
write_labelled_spss(mtcars, "mtcars.csv")

}
}

