% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rows.R
\name{add_rows}
\alias{.add_rows}
\alias{\%add_rows\%}
\alias{add_rows}
\alias{add_rows.data.frame}
\title{Add rows to data.frame/matrix/table}
\usage{
add_rows(...)

\method{add_rows}{data.frame}(..., nomatch_columns = c("add", "drop", "stop"))

x \%add_rows\% y

.add_rows(..., nomatch_columns = c("add", "drop", "stop"))
}
\arguments{
\item{...}{data.frame/matrix/table for binding}

\item{nomatch_columns}{action if there are non-matching columns between
data.frames. Possible values are \code{"add"}, \code{"drop"}, \code{"stop"}.
\code{"add"} will combine all columns, \code{"drop"} will leave only common
columns, \code{"stop"} will raise an error.}

\item{x}{data.frame/matrix/table for binding}

\item{y}{data.frame/matrix/table for binding}
}
\value{
See \link[base]{rbind}, \link{cro}, \link{fre}
}
\description{
\code{add_rows} is similar to \link[base]{rbind} but it handles non-matching 
column names. \code{\%add_rows\%} is an infix version of \code{add_rows}. 
There is also special method for the results of \code{cro_*}/\code{fre}. 
\code{.add_rows} is version for addding rows to default dataset. See
\link{default_dataset}.
}
\examples{
a = data.frame(x = 1:5, y = 6:10)
b = data.frame(y = 6:10, z = 11:15)

add_rows(a, b) # x, y, z
a \%add_rows\% b # the same result

add_rows(a, b, nomatch_columns = "drop")  # y

# simple tables
data(mtcars)

mtcars = modify(mtcars, {
            var_lab(mpg) = "Miles/(US) gallon"
            var_lab(vs) = "vs"
            val_lab(vs) = c("V-engine" = 0, "Straight engine" = 1)
            var_lab(am) = "am"
            val_lab(am) = c("automatic transmission" = 1, "manual transmission" = 0)
            var_lab(gear) = "gear"
            var_lab(carb) = "carb"
})

tab_mean = with(mtcars, cro_mean(mpg, am))
tab_percent = with(mtcars, cro_cpct(vs, am))

tab_mean \%add_rows\% tab_percent

}

