% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_monograph.R
\name{extr_monograph}
\alias{extr_monograph}
\title{Retrieve WHO IARC Monograph Information}
\usage{
extr_monograph(ids, search_type = "casrn", verbose = TRUE, get_all = FALSE)
}
\arguments{
\item{ids}{A character vector of IDs to search for.}

\item{search_type}{A character string specifying the type of search to
perform. Valid options are "casrn" (CAS Registry Number) and "name"
.  (name of the chemical). If \code{search_type} is "casrn", the function filters
.  by the CAS Registry Number.
If \code{search_type} is "name", the function performs a partial match search
for the chemical name.}

\item{verbose}{A logical value indicating whether to print detailed messages.
.   Default is TRUE.}

\item{get_all}{Logical. If TRUE ignore all the other ignore \code{ids},
\code{search_type}, set  \code{force = TRUE} and get the all dataset.
This is was introduced for debugging purposes.}
}
\value{
A data frame containing the relevant information from the WHO IARC,
.  including Monograph \code{volume}, \code{volume_publication_year}, \code{evaluation_year},
.  and \code{additional_information} where the chemical was described.
}
\description{
This function returns information regarding Monographs from the World Health
Organization (WHO) International Agency for Research on Cancer (IARC)  based on
CAS Registry Number or Name of the chemical. Note that the data is not fetched
dynamically from the website, but has retrieved and  copy hasbeen saved as
internal data in the package.
}
\examples{
{
  dat <- extr_monograph(search_type = "casrn", ids = c("105-74-8", "120-58-1"))
  str(dat)

  # Example usage for name search
  dat2 <- extr_monograph(
    search_type = "name",
    ids = c("Aloe", "Schistosoma", "Styrene")
  )
  str(dat2)
}
}
\seealso{
\url{https://monographs.iarc.who.int/list-of-classifications/}
}
