% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{datestamp}
\alias{datestamp}
\title{Date stamping periods of mildly explosive behaviour}
\usage{
datestamp(object, cv, option = c("gsadf", "sadf"), min_duration = 0)
}
\arguments{
\item{object}{An object of class \code{\link[=radf]{radf()}}.}

\item{cv}{An object of class "cv". The output of \code{\link[=mc_cv]{mc_cv()}},
\code{\link[=wb_cv]{wb_cv()}} or \code{\link[=sb_cv]{sb_cv()}}}

\item{option}{Whether to apply the "gsadf" or "sadf" methodology. Default is
"gsadf".}

\item{min_duration}{The minimum duration of an explosive period for it to be
reported. Default is 0.}
}
\value{
Returns a list of values for each explosive sub-period, giving the origin
and termination dates as well as the number of periods explosive behavior lasts.
}
\description{
Computes the origination, termination and duration of
episodes during which the time series display explosive dynamics.
}
\details{
Datestamp also stores a vector in {0,1} that corresponds to {reject, accept}
respectively, for all series in the time period. This output can be used as
a dummy that indicates the occurrence of a bubble.

Setting \code{min_duration} removes very short episode of exuberance.
Phillips et al. (2015) propose two simple rules of thumb to remove short
periods of explosive dynamics, "log(T)/T", where T is the number of observations.
}
\references{
Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for
Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the
S&P 500. International Economic Review, 56(4), 1043-1078.
}
