## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  fig.width = 10
)

## ----load----------------------------------------------------------------
library(exuber)
options(exuber.show_progress = FALSE)
library(dplyr)
library(ggplot2)
library(tidyr)

## ----options, echo=FALSE-------------------------------------------------
options(exuber.parallel = FALSE)

## ----tstats-cv-----------------------------------------------------------
set.seed(123)
dta <- tibble(
  sim_psy1 = sim_psy1(100),
  sim_psy2 = sim_psy2(100),
  sim_evans = sim_blan(100),
  sim_blan = sim_evans(100),
) 

# Esimation
tstats <- radf(dta, lag = 1)
  
# Critical Values ~ Conservative
cv <- mc_cv(nrow(dta), opt_bsadf = "conservative")

## ----autoplot------------------------------------------------------------
autoplot(tstats, cv)

## ----autoplot-modify-----------------------------------------------------
plots <- autoplot(tstats, cv, arrange = FALSE)

mod_plot <- plots[[1]] + 
  labs(x = "index", y = "Statistic", title = "Simulation of a single-bubble process")
mod_plot

## ----reconstruct---------------------------------------------------------
plots[[1]] <- mod_plot
plots[1:2] %>% 
  ggarrange()

## ----join-sets-----------------------------------------------------------
joined <- augment_join(tstats, cv)
joined 

## ----facet-joined, warning=FALSE-----------------------------------------
library(ggplot2)
joined %>%
  ggplot(aes(x = index)) +
  geom_line(aes(y = tstat)) +
  geom_line(aes(y = crit, col = "red")) +
  facet_grid(id ~ name + sig , scales = "free_y") +
  theme_bw()

## ----autoplot-fortify----------------------------------------------------
fortify(tstats, cv) %>%
  gather(id, tstat, -cv, -index, factor_key = TRUE) %>%
  ggplot(aes(x = index)) +
  geom_line(aes(y = tstat)) +
  geom_line(aes(y = cv, col = "red", linetype = "dotted")) +
  facet_wrap(~ id , scales = "free_y") +
  theme_bw() + theme(strip.background = element_blank(),
                     legend.position = "none") +
  labs(x = "", y = "")

## ----fortify-autoplot-datestamp, eval=FALSE, include=FALSE---------------
#  bind_cols(
#    fortify(tstats, cv) %>%
#      gather(id, tstat, -index),
#    fortify(tstats, cv = wb_cv(dta)) %>%
#      gather(id, crit, -psy1, -psy2, -index)
#  ) %>%
#    select(index, id, crit, tstat) %>%
#    ggplot(aes(x = index)) +
#    geom_line(aes(y = tstat)) +
#    geom_line(aes(y = crit, color = "red"), linetype = "dashed") +
#    facet_wrap(~ id, ncol = 1) +
#    theme_bw()

## ----distributions-------------------------------------------------------
dist <- mc_distr(n = 300)
autoplot(dist)

## ----ecdf----------------------------------------------------------------
library(tidyr)
dist %>%
  tidy() %>%
  rename_all(~ stringr::str_to_upper(.)) %>%
  gather(Statistic, value, factor_key = TRUE) %>%
  ggplot(aes(value, color = Statistic)) +
  stat_ecdf() +
  ggtitle("Empirical Cumulative Distribution Function") +
  geom_hline(yintercept = 0.95, linetype = "dashed") + theme_bw()

