% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eyes.R
\name{eyes}
\alias{eyes}
\alias{eyestr}
\title{Count patients and eyes}
\usage{
eyes(x, id = NULL, eye = NULL, report = FALSE, ...)

eyestr(x, id = NULL, eye = NULL, small_num = TRUE, para = FALSE, UK = FALSE)
}
\arguments{
\item{x}{required. (data frame)}

\item{id}{Patient identifying column}

\item{eye}{Eye identifying column.}

\item{report}{if TRUE, text returned for report}

\item{...}{passed to \link{eyes_to_string}}

\item{small_num}{If TRUE: writing numbers <= 12 as words}

\item{para}{If TRUE: Adding "A total of" to comply with most
journal standards and to avoid awkward long numbers.}

\item{UK}{Logical, Use UK (English) style (TRUE) or
USA (American) style (FALSE).}
}
\value{
\code{eyes}: Named integer vector with count of patients and eyes

\code{eyestr}: Character string - can be directly pasted into reports
}
\description{
Counts number of patients and eyes (right and left).

\code{eyestr}: identical to \code{eyes(x, report = TRUE, ...)}
}
\details{
\code{eyes} guesses columns that identify patients and eyes.
}
\section{Guessing}{

For any below, \strong{cases are always ignored} (you can write in
upper or lower case, as you please)

\strong{id} and \strong{eye} arguments overrule the name guessing for
the respective columns.

\strong{patient ID columns}:
\itemize{
\item First, \code{eyes} is looking for names that contain both strings
"pat" and "id" (the order doesn't matter)
\item Next, it will look for columns that are plainly called "ID"
\item Last, it will search for all names that contain either "pat"
or "id"
}

\strong{eye variable column}:
\itemize{
\item \code{eyes} looks for columns called either "eye" or "eyes"
}
}

\section{Eye coding}{

\itemize{
\item \code{eyes} recognizes integer coding 0:1 and 1:2, with right being
the lower number. For strings coding it recognizes
right eyes: c("r", "re", "od", "right") and
left eyes: c("l", "le", "os", "left")
}
}

\section{Report}{

Using \link{eyes_to_string} to parse the output of \code{eyes} into
a text which you can use for reports. Arguments to \code{eyes_to_string}
are passed via \strong{...}:
\itemize{
\item \strong{small_num} If TRUE (default): numbers <= 12 as words
\item \strong{para} If TRUE (not default): Adding "A total of" to
comply with most journal standards and to avoid awkward
long numbers.
\item \strong{UK} TRUE: UK style (English) or FALSE (default):
US style (American).
}
}

\examples{
eyes(amd)
eyestr(amd, para = TRUE)
}
\concept{eye core functions}
