% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_edf.R
\name{read_edf}
\alias{read_edf}
\title{Read EDF file with gaze data recorded by SR Research EyeLink eye tracker}
\usage{
read_edf(
  file,
  consistency = "check consistency and report",
  import_events = TRUE,
  import_recordings = TRUE,
  import_samples = FALSE,
  sample_attributes = NULL,
  start_marker = "TRIALID",
  end_marker = "TRIAL_RESULT",
  import_saccades = TRUE,
  import_blinks = TRUE,
  import_fixations = TRUE,
  import_variables = TRUE,
  verbose = TRUE,
  fail_loudly = TRUE
)
}
\arguments{
\item{file}{full name of the EDF file}

\item{consistency}{consistency check control for the time stamps of the start
and end events, etc. Could be \code{'no consistency check'},
\code{'check consistency and report'} (default), \code{'check consistency and fix'}.}

\item{import_events}{logical, whether to import events, defaults to
code{TRUE}}

\item{import_recordings}{logical, whether to import information about start/end of the recording, defaults to
code{TRUE}}

\item{import_samples}{logical, whether to import samples, defaults to \code{FALSE}.
Please note that specifying\code{sample_attributes} automatically sets it to \code{TRUE}.}

\item{sample_attributes}{a character vector that lists sample attributes to be imported.
By default, all attributes are imported (default). For the complete list of sample attributes
please refer to \code{\link{eyelinkRecording}} or EDF API documentation.}

\item{start_marker}{event string that marks the beginning of the trial. Defaults to \code{"TRIALID"}.}

\item{end_marker}{event string that marks the end of the trial. Defaults to \code{"TRIAL_RESULT"}.
Please note that an \strong{empty} string \code{''} means that a trial lasts from one \code{start_marker} till the next one.}

\item{import_saccades}{logical, whether to extract saccade events into a separate table for convenience. Defaults to \code{TRUE}.}

\item{import_blinks}{logical, whether to extract blink events into a separate table for convenience. Defaults to \code{TRUE}.}

\item{import_fixations}{logical, whether to extract fixation events into a separate table for convenience. Defaults to \code{TRUE}.}

\item{import_variables}{logical, whether to extract stored variables into a separate table for convenience. Defaults to \code{TRUE}.}

\item{verbose}{logical, whether the number of trials and the progress are shown in the console. Defaults to \code{TRUE}.}

\item{fail_loudly}{logical, whether lack of compiled library means
error (\code{TRUE}, default) or just warning (\code{FALSE}).}
}
\value{
an \code{\link{eyelinkRecording}} object that contains events, samples,
and recordings, as well as specific events such as saccades, fixations, blinks, etc.
}
\description{
Reads EDF file with gaze data recorded by SR Research EyeLink eye tracker
and returns an \code{\link{eyelinkRecording}} object that contains events, samples,
and recordings, as well as specific events such as saccades, fixations, blinks, etc.
}
\examples{
\donttest{
  if (eyelinkReader::compiled_library_status()) {
    # Import only events and recordings information
    recording <- read_edf(system.file("extdata", "example.edf", package = "eyelinkReader"))

    # Import events and samples (only time and  screen gaze coordinates)
    recording <- read_edf(system.file("extdata", "example.edf", package = "eyelinkReader"),
                          sample_attributes = c('time', 'gx', 'gy'))

    # Import events and samples (all attributes)
    recording <- read_edf(system.file("extdata", "example.edf", package = "eyelinkReader"),
                          import_samples= TRUE)
  }
}
}
