% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_window_data.R
\name{plot.time_window_data}
\alias{plot.time_window_data}
\title{Plot a time-window dataset}
\usage{
\method{plot}{time_window_data}(x, predictor_columns = NULL, dv = "Prop",
  ...)
}
\arguments{
\item{x}{The data returned by make_time_window_data()}

\item{predictor_columns}{Up to two columns indicating predictors. The first maps to the X-axis,
the second to group/color. If the latter is numeric, a median split is performed.}

\item{dv}{Which dv should be used in plotting? Raw proportion-looking ("Prop"), empirical logit
("Elog"), or "ArcSin"?}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
Plots the data returned from \code{make_time_window_data}. Data can be mapped onto (up to two)
predictor columns. If no predictor columns are supplied, AOI is placed on the x-axis; otherwise,
data for each AOI is set in a separate facet.
}
\details{
Data are collapsed by-participants for plotting.
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE)
response_window_agg_by_sub <- make_time_window_data(data, 
                                                    aois='Animate',
                                                    predictor_columns=c('Age','MCDI_Total'))
                                                    
plot(response_window_agg_by_sub, predictor_columns="Age", dv = "LogitAdjusted") 

}
