% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R
\name{forecast.ETS}
\alias{forecast.ETS}
\title{Forecast a model from the fable package}
\usage{
\method{forecast}{ETS}(
  object,
  new_data,
  specials = NULL,
  simulate = FALSE,
  bootstrap = FALSE,
  times = 5000,
  ...
)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{specials}{(passed by \code{\link[fabletools:forecast.mdl_df]{fabletools::forecast.mdl_df()}}).}

\item{simulate}{If \code{TRUE}, prediction intervals are produced by simulation rather than using analytic formulae.}

\item{bootstrap}{If \code{TRUE}, then forecast distributions are computed using simulation with resampled errors.}

\item{times}{The number of sample paths to use in estimating the forecast distribution if simulated intervals are used.}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A list of forecasts.
}
\description{
Produces forecasts from a trained model.
}
\examples{
as_tsibble(USAccDeaths) \%>\%
  model(ets = ETS(log(value) ~ season("A"))) \%>\% 
  forecast()

}
