% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/definitions.R
\name{new_model_class}
\alias{new_model_class}
\alias{new_model_definition}
\title{Create a new class of models}
\usage{
new_model_class(
  model = "Unknown model",
  train = function(.data, formula, specials, ...)
    abort("This model has not defined a training method."),
  specials = new_specials(),
  check = function(.data) { },
  prepare = function(...) { },
  ...,
  .env = caller_env(),
  .inherit = model_definition
)

new_model_definition(.class, ..., .env = caller_env(n = 2))
}
\arguments{
\item{model}{The name of the model}

\item{train}{A function that trains the model to a dataset. \code{.data} is a tsibble
containing the data's index and response variables only. \code{formula} is the
user's provided formula. \code{specials} is the evaluated specials used in the formula.}

\item{specials}{Special functions produced using \code{\link[=new_specials]{new_specials()}}}

\item{check}{A function that is used to check the data for suitability with
the model. This can be used to check for missing values (both implicit and
explicit), regularity of observations, ordered time index, and univariate
responses.}

\item{prepare}{This allows you to modify the model class according to user
inputs. \code{...} is the arguments passed to \code{new_model_definition}, allowing
you to perform different checks or training procedures according to different
user inputs.}

\item{...}{Further arguments to \code{\link[R6:R6Class]{R6::R6Class()}}. This can be useful to set up
additional elements used in the other functions. For example, to use
\code{common_xregs}, an \code{origin} element in the model is used to store
the origin for \code{trend()} and \code{fourier()} specials. To use these specials, you
must add an \code{origin} element to the object (say with \code{origin = NULL}).}

\item{.env}{The environment from which functions should inherit from.}

\item{.inherit}{A model class to inherit from.}

\item{.class}{A model class (typically created with \code{\link[=new_model_class]{new_model_class()}})}
}
\description{
Suitable for extension packages to create new models for fable.
}
\details{
This function produces a new R6 model definition. An understanding of R6 is
not required, however could be useful to provide more sophisticated model
interfaces. All functions have access to \code{self}, allowing the functions for
training the model and evaluating specials to access the model class itself.
This can be useful to obtain elements set in the \%TODO
}
