% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_scales.R
\name{scale_level}
\alias{scale_level}
\alias{scale_level_gradient}
\alias{scale_level_continuous}
\title{Level colour scales}
\usage{
scale_level_gradient(
  ...,
  low = "#888888",
  high = "#BBBBBB",
  space = "Lab",
  na.value = NA,
  guide = "level"
)

scale_level_continuous(
  ...,
  low = "#888888",
  high = "#BBBBBB",
  space = "Lab",
  na.value = NA,
  guide = "level"
)
}
\arguments{
\item{...}{Arguments passed on to \code{continuous_scale}
\describe{
  \item{scale_name}{The name of the scale}
  \item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding values in the range the
scale maps to.}
  \item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
}}
  \item{rescaler}{Used by diverging and n colour gradients
(i.e. \code{\link[ggplot2:scale_colour_gradient2]{scale_colour_gradient2()}}, \code{\link[ggplot2:scale_colour_gradientn]{scale_colour_gradientn()}}).
A function used to scale the input values to the range [0, 1].}
  \item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with \code{NA}.}
  \item{trans}{Either the name of a transformation object, or the
object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \code{name_trans}, e.g.
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}. You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}
  \item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}
  \item{super}{The super class to use for the constructed scale}
  \item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expand_scale]{expand_scale()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
}}

\item{low, high}{Colours for low and high ends of the gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new scales for level geoms equivalent to the
ones already defined by ggplot2. This allows the shade of confidence intervals
to work with the legend output.
}
\concept{scale_level_*}
