% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast}
\alias{forecast}
\alias{forecast.mdl_df}
\alias{forecast.mdl_ts}
\title{Produce forecasts}
\usage{
forecast(object, ...)

\method{forecast}{mdl_df}(
  object,
  new_data = NULL,
  h = NULL,
  point_forecast = list(.mean = mean),
  ...
)

\method{forecast}{mdl_ts}(
  object,
  new_data = NULL,
  h = NULL,
  bias_adjust = NULL,
  point_forecast = list(.mean = mean),
  ...
)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{h}{The forecast horison (can be used instead of \code{new_data} for regular
time series with no exogenous regressors).}

\item{point_forecast}{The point forecast measure(s) which should be returned
in the resulting fable. Specified as a named list of functions which accept
a distribution and return a vector. To compute forecast medians, you can use
\code{list(.median = median)}.}

\item{bias_adjust}{Deprecated. Please use \code{point_forecast} to specify the
desired point forecast method.}
}
\value{
A fable containing the following columns:
\itemize{
\item \code{.model}: The name of the model used to obtain the forecast. Taken from
the column names of models in the provided mable.
\item The forecast distribution. The name of this column will be the same as the
dependent variable in the model(s). If multiple dependent variables exist,
it will be named \code{.distribution}.
\item Point forecasts computed from the distribution using the functions in the
\code{point_forecast} argument.
\item All columns in \code{new_data}, excluding those whose names conflict with the
above.
}
}
\description{
The forecast function allows you to produce future predictions of a time series
from fitted models. If the response variable has been transformed in the
model formula, the transformation will be automatically back-transformed
(and bias adjusted if \code{bias_adjust} is \code{TRUE}). More details about
transformations in the fable framework can be found in
\code{vignette("transformations", package = "fable")}.
}
\details{
The forecasts returned contain both point forecasts and their distribution.
A specific forecast interval can be extracted from the distribution using the
\code{\link[=hilo]{hilo()}} function, and multiple intervals can be obtained using \code{\link[=report]{report()}}.
These intervals are stored in a single column using the \code{hilo} class, to
extract the numerical upper and lower bounds you can use \code{\link[=unpack_hilo]{unpack_hilo()}}.
}
\examples{
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)
library(tsibble)
library(tsibbledata)
library(dplyr)
library(tidyr)

# Forecasting with an ETS(M,Ad,A) model to Australian beer production
beer_fc <- aus_production \%>\%
  model(ets = ETS(log(Beer) ~ error("M") + trend("Ad") + season("A"))) \%>\% 
  forecast(h = "3 years")

# Compute 80\% and 95\% forecast intervals
beer_fc \%>\% 
  hilo(level = c(80, 95))

beer_fc \%>\% 
  autoplot(aus_production)

# Forecasting with a seasonal naive and linear model to the monthly 
# "Food retailing" turnover for each Australian state/territory.
library(dplyr)
aus_retail \%>\% 
  filter(Industry == "Food retailing") \%>\% 
  model(
    snaive = SNAIVE(Turnover),
    ets = TSLM(log(Turnover) ~ trend() + season()),
  ) \%>\% 
  forecast(h = "2 years 6 months") \%>\% 
  autoplot(filter(aus_retail, Month >= yearmonth("2000 Jan")), level = 90)
  
# Forecast GDP with a dynamic regression model on log(GDP) using population and
# an automatically chosen ARIMA error structure. Assume that population is fixed
# in the future.
aus_economy <- global_economy \%>\% 
  filter(Country == "Australia")
fit <- aus_economy \%>\% 
  model(lm = ARIMA(log(GDP) ~ Population))

future_aus <- new_data(aus_economy, n = 10) \%>\% 
  mutate(Population = last(aus_economy$Population))

fit \%>\% 
  forecast(new_data = future_aus) \%>\% 
  autoplot(aus_economy)
}

}
