% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_aggregation.R
\name{aggregate_index}
\alias{aggregate_index}
\title{Expand a dataset to include temporal aggregates}
\usage{
aggregate_index(.data, .window, ..., .offset = "end", .bin_size = NULL)
}
\arguments{
\item{.data}{A tsibble.}

\item{.window}{Temporal aggregations to include. The default (NULL) will
automatically identify appropriate temporal aggregations. This can be
specified in several ways (see details).}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame, to add multiple columns from a single expression.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Returning values with size 0 or >1 was
deprecated as of 1.1.0. Please use \code{\link[dplyr:reframe]{reframe()}} for this instead.}

\item{.offset}{Offset the temporal aggregation windows to align with the start
or end of the data. If FALSE, no offset will be applied (giving common
breakpoints for temporal bins.)}

\item{.bin_size}{Temporary. Define the number of observations in each temporal bucket}
}
\description{
\lifecycle{experimental}
}
\details{
This feature is very experimental. It currently allows for temporal
aggregation of daily data as a proof of concept.

The aggregation \code{.window} can be specified in several ways:
\itemize{
\item A character string, containing one of "day", "week", "month", "quarter" or
"year". This can optionally be preceded by a (positive or negative) integer
and a space, or followed by "s".
\item A number, taken to be in days.
\item A \code{\link{difftime}} object.
}
}
\examples{
library(tsibble)
pedestrian \%>\%
  # Currently only supports daily data
  index_by(Date) \%>\% 
  dplyr::summarise(Count = sum(Count)) \%>\% 
  # Compute weekly aggregates
  fabletools:::aggregate_index("1 week", Count = sum(Count))
}
