% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomGrouping.R
\name{create_randomised_groups}
\alias{create_randomised_groups}
\title{Create randomised groups
Creates randomised groups, e.g. for tests that depend on splitting (continuous) data into groups, such as the Hosmer-Lemeshow test}
\usage{
create_randomised_groups(
  x,
  y = NULL,
  sample_identifiers,
  n_max_groups = NULL,
  n_min_groups = NULL,
  n_min_y_in_group = NULL,
  n_groups_init = 30,
  fast_mode = TRUE
)
}
\arguments{
\item{x}{Vector with data used for sorting. Groups are formed based on adjacent values.}

\item{y}{Vector with markers, e.g. the events. Should be 0 or 1 (for an event).}

\item{sample_identifiers}{data.table with sample_identifiers. If provide, a list of grouped sample_identifiers will be returned, and integers otherwise.}

\item{n_max_groups}{Maximum number of groups that need to be formed.}

\item{n_min_groups}{Minimum number of groups that need to be formed.}

\item{n_min_y_in_group}{Minimum number of y=1 in each group for a valid group.}

\item{n_groups_init}{Number of initial groups (default: 30)}

\item{fast_mode}{Enables fast randomised grouping mode (default: TRUE)}
}
\value{
List of group sample ids or indices.
}
\description{
The default fast mode is based on random sampling, whereas the slow mode is based on probabilistic joining of adjacent groups. As
the name suggests, fast mode operates considerably more efficient.
}
\keyword{internal}
