% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationFeatureSimilarity.R
\name{extract_feature_similarity}
\alias{extract_feature_similarity}
\title{Internal function to extract the feature distance table.}
\usage{
extract_feature_similarity(
  object,
  data,
  cl = NULL,
  estimation_type = waiver(),
  aggregate_results = waiver(),
  confidence_level = waiver(),
  bootstrap_ci_method = waiver(),
  is_pre_processed = FALSE,
  feature_cluster_method = waiver(),
  feature_linkage_method = waiver(),
  feature_cluster_cut_method = waiver(),
  feature_similarity_threshold = waiver(),
  feature_similarity_metric = waiver(),
  verbose = FALSE,
  message_indent = 0L,
  ...
)
}
\arguments{
\item{object}{A \code{familiarEnsemble} object, which is an ensemble of one or more
\code{familiarModel} objects.}

\item{data}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}

\item{cl}{Cluster created using the \code{parallel} package. This cluster is then
used to speed up computation through parallellisation.}

\item{estimation_type}{(\emph{optional}) Sets the type of estimation that should be
possible. This has the following options:
\itemize{
\item \code{point}: Point estimates.
\item \code{bias_correction} or \code{bc}: Bias-corrected estimates. A bias-corrected
estimate is computed from (at least) 20 point estimates, and \code{familiar} may
bootstrap the data to create them.
\item \code{bootstrap_confidence_interval} or \code{bci} (default): Bias-corrected
estimates with bootstrap confidence intervals (Efron and Hastie, 2016). The
number of point estimates required depends on the \code{confidence_level}
parameter, and \code{familiar} may bootstrap the data to create them.
}

As with \code{detail_level}, a non-default \code{estimation_type} parameter can be
specified for separate evaluation steps by providing a parameter value in a
named list with data elements, e.g. \code{list("auc_data"="bci", "model_performance"="point")}. This parameter can be set for the following
data elements: \code{auc_data}, \code{decision_curve_analyis}, \code{model_performance},
\code{permutation_vimp}, \code{ice_data}, and \code{prediction_data}.}

\item{aggregate_results}{(\emph{optional}) Flag that signifies whether results
should be aggregated during evaluation. If \code{estimation_type} is
\code{bias_correction} or \code{bc}, aggregation leads to a single bias-corrected
estimate. If \code{estimation_type} is \code{bootstrap_confidence_interval} or \code{bci},
aggregation leads to a single bias-corrected estimate with lower and upper
boundaries of the confidence interval. This has no effect if
\code{estimation_type} is \code{point}.

The default value is equal to \code{TRUE} except when assessing metrics to assess
model performance, as the default violin plot requires underlying data.

As with \code{detail_level} and \code{estimation_type}, a non-default
\code{aggregate_results} parameter can be specified for separate evaluation steps
by providing a parameter value in a named list with data elements, e.g.
\code{list("auc_data"=TRUE, , "model_performance"=FALSE)}. This parameter exists
for the same elements as \code{estimation_type}.}

\item{confidence_level}{(\emph{optional}) Numeric value for the level at which
confidence intervals are determined. In the case bootstraps are used to
determine the confidence intervals bootstrap estimation, \code{familiar} uses the
rule of thumb \eqn{n = 20 / ci.level} to determine the number of required
bootstraps.

The default value is \code{0.95}.}

\item{bootstrap_ci_method}{(\emph{optional}) Method used to determine bootstrap
confidence intervals (Efron and Hastie, 2016). The following methods are
implemented:
\itemize{
\item \code{percentile} (default): Confidence intervals obtained using the percentile
method.
\item \code{bc}: Bias-corrected confidence intervals.
}

Note that the standard method is not implemented because this method is
often not suitable due to non-normal distributions. The bias-corrected and
accelerated (BCa) method is not implemented yet.}

\item{is_pre_processed}{Flag that indicates whether the data was already
pre-processed externally, e.g. normalised and clustered. Only used if the
\code{data} argument is a \code{data.table} or \code{data.frame}.}

\item{feature_cluster_method}{The method used to perform clustering. These are
the same methods as for the \code{cluster_method} configuration parameter:
\code{none}, \code{hclust}, \code{agnes}, \code{diana} and \code{pam}.

\code{none} cannot be used when extracting data regarding mutual correlation or
feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_cluster_cut_method}{The method used to divide features into
separate clusters. The available methods are the same as for the
\code{cluster_cut_method} configuration parameter: \code{silhouette}, \code{fixed_cut} and
\code{dynamic_cut}.

\code{silhouette} is available for all cluster methods, but \code{fixed_cut} only
applies to methods that create hierarchical trees (\code{hclust}, \code{agnes} and
\code{diana}). \code{dynamic_cut} requires the \code{dynamicTreeCut} package and can only
be used with \code{agnes} and \code{hclust}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_similarity_threshold}{The threshold level for pair-wise
similarity that is required to form feature clusters with the \code{fixed_cut}
method.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_similarity_metric}{Metric to determine pairwise similarity
between features. Similarity is computed in the same manner as for
clustering, and \code{feature_similarity_metric} therefore has the same options
as \code{cluster_similarity_metric}: \code{mcfadden_r2}, \code{cox_snell_r2},
\code{nagelkerke_r2}, \code{spearman}, \code{kendall} and \code{pearson}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{verbose}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}

\item{message_indent}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}

\item{...}{Unused arguments.}
}
\value{
A data.table containing pairwise distance between features. This data
is only the upper triangular of the complete matrix (i.e. the sparse
unitriangular representation). Diagonals will always be 0.0 and the lower
triangular is mirrored.
}
\description{
Computes and extracts the feature distance table for features
used in a \code{familiarEnsemble} object. This table can be used to cluster
features, and is exported directly by \code{export_feature_similarity}.
}
\keyword{internal}
