% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationSampleSimilarity.R
\name{extract_sample_similarity}
\alias{extract_sample_similarity}
\title{Internal function to extract the sample distance table.}
\usage{
extract_sample_similarity(
  object,
  data,
  cl = NULL,
  is_pre_processed = FALSE,
  sample_limit = waiver(),
  sample_cluster_method = waiver(),
  sample_linkage_method = waiver(),
  sample_similarity_metric = waiver(),
  verbose = FALSE,
  message_indent = 0L,
  ...
)
}
\arguments{
\item{object}{A \code{familiarEnsemble} object, which is an ensemble of one or more
\code{familiarModel} objects.}

\item{data}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}

\item{cl}{Cluster created using the \code{parallel} package. This cluster is then
used to speed up computation through parallellisation.}

\item{is_pre_processed}{Flag that indicates whether the data was already
pre-processed externally, e.g. normalised and clustered. Only used if the
\code{data} argument is a \code{data.table} or \code{data.frame}.}

\item{sample_limit}{(\emph{optional}) Set the upper limit of the number of samples
that are used during evaluation steps. Cannot be less than 20.

This setting can be specified per data element by providing a parameter
value in a named list with data elements, e.g.
\code{list("sample_similarity"=100, "permutation_vimp"=1000)}.

This parameter can be set for the following data elements:
\code{sample_similarity} and \code{ice_data}.}

\item{sample_cluster_method}{The method used to perform clustering based on
distance between samples. These are the same methods as for the
\code{cluster_method} configuration parameter: \code{hclust}, \code{agnes}, \code{diana} and
\code{pam}.

\code{none} cannot be used when extracting data for feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{sample_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{sample_similarity_metric}{Metric to determine pairwise similarity
between samples. Similarity is computed in the same manner as for
clustering, but \code{sample_similarity_metric} has different options that are
better suited to computing distance between samples instead of between
features: \code{gower}, \code{euclidean}.

The underlying feature data is scaled to the \eqn{[0, 1]} range (for
numerical features) using the feature values across the samples. The
normalisation parameters required can optionally be computed from feature
data with the outer 5\% (on both sides) of feature values trimmed or
winsorised. To do so append \verb{_trim} (trimming) or \verb{_winsor} (winsorising) to
the metric name. This reduces the effect of outliers somewhat.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{verbose}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}

\item{message_indent}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}

\item{...}{Unused arguments.}
}
\value{
A data.table containing pairwise distance between samples. This data
is only the upper triangular of the complete matrix (i.e. the sparse
unitriangular representation). Diagonals will always be 0.0 and the lower
triangular is mirrored.
}
\description{
Computes and extracts the sample distance table for samples
analysed using a \code{familiarEnsemble} object to form a \code{familiarData} object. This table can be used to cluster
samples, and is exported directly by \code{extract_feature_expression}.
}
\keyword{internal}
