% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{featureInfo-class}
\alias{featureInfo-class}
\title{Feature information object.}
\description{
A featureInfo object contains information for a single feature. This
information is used to check data prospectively for consistency and for data
preparation. These objects are, for instance, attached to a familiarModel
object so that data can be pre-processed in the same way as the development
data.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the feature, which by default is the column name of the
feature.}

\item{\code{set_descriptor}}{Character string describing the set to which the feature
belongs. Currently not used.}

\item{\code{feature_type}}{Describes the feature type, i.e. \code{factor} or \code{numeric}.}

\item{\code{levels}}{The class levels of categorical features. This is used to check
prospective datasets.}

\item{\code{ordered}}{Specifies whether the}

\item{\code{distribution}}{Five-number summary (numeric) or class frequency
(categorical).}

\item{\code{data_id}}{Internal identifier for the dataset used to derive the feature
information.}

\item{\code{run_id}}{Internal identifier for the specific subset of the dataset used
to derive the feature information.}

\item{\code{in_signature}}{Specifies whether the feature is included in the model
signature.}

\item{\code{in_novelty}}{Specifies whether the feature is included in the novelty
detector.}

\item{\code{removed}}{Specifies whether the feature was removed during
pre-processing.}

\item{\code{removed_unknown_type}}{Specifies whether the feature was removed during
pre-processing because the type was neither factor nor numeric..}

\item{\code{removed_missing_values}}{Specifies whether the feature was removed during
pre-processing because it contained too many missing values.}

\item{\code{removed_no_variance}}{Specifies whether the feature was removed during
pre-processing because it did not contain more than 1 unique value.}

\item{\code{removed_low_variance}}{Specifies whether the feature was removed during
pre-processing because the variance was too low. Requires applying
\code{low_variance} as a \code{filter_method}.}

\item{\code{removed_low_robustness}}{Specifies whether the feature was removed during
pre-processing because it lacks robustness. Requires applying
\code{robustness} as a \code{filter_method}, as well as repeated measurement.}

\item{\code{removed_low_importance}}{Specifies whether the feature was removed during
pre-processing because it lacks relevance. Requires applying
\code{univariate_test} as a \code{filter_method}.}

\item{\code{fraction_missing}}{Specifies the fraction of missing values.}

\item{\code{robustness}}{Specifies robustness of the feature, if measured.}

\item{\code{univariate_importance}}{Specifies the univariate p-value of the feature, if measured.}

\item{\code{transformation_parameters}}{Details parameters for power transformation of numeric features.}

\item{\code{normalisation_parameters}}{Details parameters for (global) normalisation of numeric features.}

\item{\code{batch_normalisation_parameters}}{Details parameters for batch normalisation of numeric features.}

\item{\code{imputation_parameters}}{Details parameters or models for imputation of missing values.}

\item{\code{cluster_parameters}}{Details parameters for forming clusters with other features.}

\item{\code{required_features}}{Details features required for clustering or imputation.}

\item{\code{familiar_version}}{Version of the familiar package.}
}}

