% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarCollection.R
\name{set_learner_names,familiarCollection-method}
\alias{set_learner_names,familiarCollection-method}
\alias{set_learner_names}
\title{Rename learners for plotting and export}
\usage{
\S4method{set_learner_names}{familiarCollection}(x, old = NULL, new = NULL, order = NULL)
}
\arguments{
\item{x}{A familiarCollection object.}

\item{old}{(optional) Set of old labels to replace.}

\item{new}{Set of replacement labels. The number of replacement labels should
be equal to the number of provided old labels or the full number of labels.
If a subset of labels is to be replaced, both \code{old} and \code{new}
should be provided.}

\item{order}{(optional) Ordered set of replacement labels. This is used to
provide the order in which the labels should be placed, which affects e.g.
levels in a plot. If the ordering is not explicitly provided, the old
ordering is used.}
}
\value{
A familiarCollection object with custom labels for the learners.
}
\description{
Tabular exports and figures created from a familiarCollection
object can be customised by providing names for the learners.
}
\details{
Labels convert the internal naming for learners to the requested
label at export or when plotting. This enables the use of more specific
naming, e.g. changing \code{random_forest_rfsrc} to \code{Random Forest}.
Currently assigned labels can be found using the \code{get_learner_names}
method.
}
\seealso{
\itemize{
\item \linkS4class{familiarCollection} for information concerning the
familiarCollection class. * \code{\link{get_learner_names}} for obtaining
currently assigned labels.
}
}
