\name{fat}
\alias{fat}
\docType{data}
\title{Percentage of Body Fat and Body Measurements}
\description{
 Age, weight, height, and 10 body circumference measurements are recorded for 252 men. Each man's percentage of body fat was accurately estimated by an underwater weighing technique.
}
\usage{data(fat)}
\format{
  A data frame with 252 observations on the following 18 variables.
  \describe{
    \item{\code{brozek}}{ Percent body fat using Brozek's equation, 457/Density - 414.2}
    \item{\code{siri}}{	  Percent body fat using Siri's equation, 495/Density - 450}
    \item{\code{density}}{Density (gm/$cm^3$)}
    \item{\code{age}}{	  Age (yrs)}
    \item{\code{weight}}{ Weight (lbs)}
    \item{\code{height}}{ Height (inches)}
    \item{\code{adipos}}{ Adiposity index = Weight/Height$^2$ (kg/$m^2$)}
    \item{\code{free}}{	  Fat Free Weight = (1 - fraction of body fat) * Weight, using Brozek's formula (lbs)}
    \item{\code{neck}}{	  Neck circumference (cm)}
    \item{\code{chest}}{  Chest circumference (cm)}
    \item{\code{abdom}}{  Abdomen circumference (cm) at the umbilicus and level with the iliac crest}
    \item{\code{hip}}{	  Hip circumference (cm)}
    \item{\code{thigh}}{  Thigh circumference (cm)}
    \item{\code{knee}}{	  Knee circumference (cm)}
    \item{\code{ankle}}{  Ankle circumference (cm)}
    \item{\code{biceps}}{ Extended biceps circumference (cm)}
    \item{\code{forearm}}{Forearm circumference (cm)}
    \item{\code{wrist}}{  Wrist circumference (cm) distal to the styloid processes}
  }
}
\source{
Johnson R. Journal of Statistics Education v.4, n.1 (1996)
}
\keyword{datasets}



















