% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasano_franceschini_test.R
\name{fasano.franceschini.test}
\alias{fasano.franceschini.test}
\title{Fasano Franceschini Test}
\usage{
fasano.franceschini.test(S1, S2, nBootstrap = 0, nPermute = 0, cores = 1)
}
\arguments{
\item{S1}{a \verb{[n by 2]} \code{data.frame} of x and y coordinates of sample 1}

\item{S2}{a \verb{[n by 2]} \code{data.frame} of x and y coordinates of sample 2}

\item{nBootstrap}{a depreciated \code{numeric} argument defining the number of bootstrapped samples to be generated for computing the empirical p-value. nBootstrap is set to be replaced by nPermute in the next released version of the package.}

\item{nPermute}{a \code{numeric} defining the number of permuted samples to be generated for computing the empirical p-value (note this procedure is slow and computationally expensive on the order of nPermute*O(n^2). Default is set to 0.
If nPermute is 0, the Fasano Franceschini distributional approximation is used for defining the p-value. See Fasano and Franceschini test (1987) for details.}

\item{cores}{a \code{numeric} defining the number of cores to use for processing}
}
\value{
the 2-D ks statistic and p-value
}
\description{
Computes the 2-D Kolmogorov-Smirnov two-sample test as described by Fasano and Franceschini (1987).
}
\details{
Code adapted from Press, W. H., Teukolsky, S. A., Vetterling, W. T.,, Flannery, B. P. (2007). Numerical Recipes 3rd Edition: The Art of Scientific Computing. Cambridge University Press. ISBN: 0521880688
}
\examples{
#Underlying distributions are different
#set seed for reproducible example
set.seed(123)

#create 2-D samples with different underlying distributions
sample1Data <- data.frame(x = rnorm(n = 50, mean = 0, sd = 3), y = rnorm(n = 50,mean = 0, sd = 1))
sample2Data <- data.frame(x = rnorm(n = 50, mean = 0, sd = 1), y = rnorm(n = 50,mean = 0, sd = 3))

fasano.franceschini.test(S1 = sample1Data, S2 = sample2Data)


#Underlying distributions are the same
#set seed for reproducible example
set.seed(123)

#create 2-D samples with the same underlying distributions
sample1Data <- data.frame(x = rnorm(n = 50, mean = 0, sd = 1), y = rnorm(n = 50,mean = 0, sd = 1))
sample2Data <- data.frame(x = rnorm(n = 50, mean = 0, sd = 1), y = rnorm(n = 50,mean = 0, sd = 1))

fasano.franceschini.test(S1 = sample1Data, S2 = sample2Data)

}
\references{
{
\itemize{
\item{Fasano, G., Franceschini, A. (1987) \doi{10.1093/mnras/225.1.155}. A multidimensional version of the Kolmogorov-Smirnov test. Monthly Notices of the Royal Astronomical Society 225:155-170.}
\item{Peacock J.A. (1983) \doi{10.1093/mnras/202.3.615}. Two-dimensional goodness-of-fit testing in astronomy. Monthly Notices of the Royal Astronomical Society 202:615-627.}
\item{Press, W. H., Teukolsky, S. A., Vetterling, W. T.,, Flannery, B. P. (2007). Numerical Recipes 3rd Edition: The Art of Scientific Computing. Cambridge University Press. ISBN: 0521880688}
}
}
}
