% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasstr-package.R
\docType{package}
\name{fasstr-package}
\alias{fasstr}
\alias{fasstr-package}
\title{fasstr: Analyze, Summarize, and Visualize Daily Streamflow Data}
\description{
The Flow Analysis Summary Statistics Tool for R, 'fasstr', provides various functions to tidy and screen daily stream discharge data, calculate and visualize various summary statistics and metrics, and compute annual trending and volume frequency analyses. It features useful function arguments for filtering of and handling dates, customizing data and metrics, and the ability to pull daily data directly from the Water Survey of Canada hydrometric database (<https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/>).
}
\references{
tidyhydat information:

To use the station_number argument of the fasstr functions, please download the latest version of HYDAT using the function:
 \itemize{
  \item \code{tidyhydat::download_hydat()}
  }


 For more information on HYDAT 
 \itemize{
   \item Please see this description of the database: goo.gl/H3NXJQ
   \item This page is landing page for technical description of HYDAT:
   \url{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/}
   \item This page links to a document that outlines database table definitions:
   \url{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/HYDAT_Definition_EN.pdf}
   }
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bcgov.github.io/fasstr/}
  \item \url{https://github.com/bcgov/fasstr}
  \item \url{https://www2.gov.bc.ca/gov/content/environment/air-land-water/water}
  \item Report bugs at \url{https://github.com/bcgov/fasstr/issues}
}

}
\author{
\strong{Maintainer}: Jon Goetz \email{jon.goetz@gov.bc.ca} (\href{https://orcid.org/0000-0002-4993-1119}{ORCID})

Authors:
\itemize{
  \item Carl James Schwarz \email{cschwarz.stat.sfu.ca@gmail.com}
}

Other contributors:
\itemize{
  \item Sam Albers \email{sam.albers@gov.bc.ca} (\href{https://orcid.org/0000-0002-9270-7884}{ORCID}) [contributor]
  \item Robin Pike \email{robin.g.pike@gov.bc.ca} [contributor]
  \item Province of British Columbia [copyright holder]
}

}
\keyword{internal}
