% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_frequency_quantile.R
\name{compute_frequency_quantile}
\alias{compute_frequency_quantile}
\title{Calculate an annual frequency analysis quantile}
\usage{
compute_frequency_quantile(
  data,
  dates = Date,
  values = Value,
  station_number,
  roll_days = NA,
  roll_align = "right",
  return_period = NA,
  use_max = FALSE,
  use_log = FALSE,
  fit_distr = c("PIII", "weibull"),
  fit_distr_method = ifelse(fit_distr == "PIII", "MOM", "MLE"),
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  ignore_missing = FALSE,
  allowed_missing = ifelse(ignore_missing, 100, 0)
)
}
\arguments{
\item{data}{A data frame of data that contains columns of events, flow values, and measures (data type).}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second. Default \code{'Value'}.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Required.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{return_period}{Numeric vector of the estimated time interval, in years, between flow events of a similar size, 
inverse of probability, used to estimate the frequency statistic. Required.}

\item{use_max}{Logical value to indicate using maximums rather than the minimums for analysis. Default \code{FALSE}.}

\item{use_log}{Logical value to indicate log-scale transforming of flow data before analysis. Default \code{FALSE}.}

\item{fit_distr}{Character string identifying the distribution to fit annual data, one of \code{'PIII'} (Log Pearson Type III)
or \code{'weibull'} (Weibull) distributions. Default \code{'PIII'}.}

\item{fit_distr_method}{Character string identifying the method used to fit the distribution, one of \code{'MOM'} (method of
moments) or \code{'MLE'} (maximum likelihood estimation). Selected as \code{'MOM'} if \code{fit_distr ='PIII'} (default) or 
\code{'MLE'} if \code{fit_distr = 'weibull'}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank or set to \code{NULL} to include all years.}

\item{months}{Numeric vector of months to include in analysis. For example, \code{3} for March, \code{6:8} for Jun-Aug or 
\code{c(10:12,1)} for first four months (Oct-Jan) when \code{water_year_start = 10} (Oct). Default summarizes all 
months (\code{1:12}).}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}

\item{allowed_missing}{Numeric value between 0 and 100 indicating the \strong{percentage} of missing dates allowed to be
included to calculate a statistic (0 to 100 percent). If \code{'ignore_missing = FALSE'} then it defaults to \code{0} (zero missing dates allowed),
if \code{'ignore_missing = TRUE'} then it defaults to \code{100} (any missing dates allowed); consistent with 
\code{ignore_missing} usage. Supersedes \code{ignore_missing} when used.}
}
\value{
A numeric value of the frequency analysis quantile, given the roll_days and return_period.
}
\description{
Performs a volume frequency analysis on annual statistics from a daily streamflow data set and calculates a statistic
   based on the provided mean n-days and return period of the statistic, defaults to minimum flows. For example, to determine the
   7Q10 of a data set, set the \code{roll_days} to \code{7} and the \code{return_period} to \code{10}. Function will calculate using 
   all values in 'Values' column (no grouped analysis), unless specified. Analysis methodology replicates that from 
   \href{https://www.hec.usace.army.mil/software/hec-ssp/}{HEC-SSP}. Returns a tibble with statistics.
}
\examples{
\dontrun{

# Working example:

# Compute the annual 7-day flow value with a 1 in 10 year return interval
compute_frequency_quantile(station_number = "08NM116",
                           roll_days = 7,
                           return_period = 10)
                            
}
}
\seealso{
\code{\link{compute_frequency_analysis}}
}
