% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroids.r
\name{centroids,GVector-method}
\alias{centroids,GVector-method}
\alias{centroids}
\title{Centroid(s) of a vector}
\usage{
\S4method{centroids}{GVector}(x, method = NULL, fail = TRUE)
}
\arguments{
\item{x}{A \code{GVector}.}

\item{method}{Character or \code{NULL} (default): Method used for calculating centroids. The method of calculation depends on whether the input is a \code{points}, \code{lines}, or \code{polygons} \code{GVector}. If the value is \code{NULL}, then the default method will be chosen, depending on the geometry type of the \code{GVector}:
\itemize{
\item \code{points}:
\itemize{
\item \code{"mean"} (default for \code{points}): Mean of coordinates.
\item \code{"median"}: Geometric median; more robust to outliers.
\item \code{"pmedian"}: Point in \code{x} closest to the geometric median.
}
\item \code{lines}:
\itemize{
\item \code{"mid"} (default for \code{lines}): Mid-point on each line; will fall exactly on the line.
\item \code{"mean"}: Center of gravity of all line segments; may not fall on the line.
\item \verb{"median}: Geometric median; may not fall on the line.
}
\item \code{polygons}:
\itemize{
\item \code{"mean"} (default for \code{polygons}): Center of gravity (area), calculated using area triangulation.
\item \code{"median"}: Geometric mean; may not fall inside the polygon.
\item \code{"bmedian"}: Geometric mean; minimum distance to boundaries; may not fall inside the polygon.
}
}

Partial matching is used and case is ignored.}

\item{fail}{Logical: If \code{TRUE} (default), and the addons folder is not correctly specified, the exit the function with an error. If \code{FALSE}, then \code{NULL} will be returned with a warning.}
}
\value{
A points \code{GVector}.
}
\description{
This function locates the centroid of each geometry of a \code{GVector}.

\strong{To use this function}, you must a) have correctly specified the \code{addonsDir} option using \code{\link[=faster]{faster()}}, and b) installed the \strong{GRASS} addon \code{v.centerpoint}. See \code{\link[=addons]{addons()}} and \code{vignette("addons", package = "fasterRaster")}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Points, lines, and polygons
madDypsis <- fastData("madDypsis")
madRivers <- fastData("madRivers")
madCoast4 <- fastData("madCoast4")

# Convert to  GVectors:
dypsis <- fast(madDypsis)
rivers <- fast(madRivers)
coast4 <- fast(madCoast4)

# Point centroids:
dypMean <- centroids(dypsis, fail = FALSE)
dypMedian <- centroids(dypsis, method = "median", fail = FALSE)
dypPMedian <- centroids(dypsis, method = "pmedian", fail = FALSE)

if (!is.null(dypMean)) {

plot(dypsis)
plot(dypMean, col = "red", add = TRUE)
plot(dypMedian, col = "green", pch = 2, add = TRUE)
plot(dypPMedian, col = "orange", pch = 1, add = TRUE)
legend("bottomright",
   legend = c("mean", "median", "pmedian"),
   col = c("red", "green", "orange"),
   pch = c(16, 2, 1),
   xpd = NA
)

}

# Line centroids:
riversMid <- centroids(rivers, fail = FALSE)
riversMean <- centroids(rivers, method = "mean", fail = FALSE)
riversMedian <- centroids(rivers, method = "median", fail = FALSE)

if (!is.null(riversMid)) {

plot(rivers)
plot(riversMid, col = "red", add = TRUE)
plot(riversMean, col = "green", pch = 2, add = TRUE)
plot(riversMedian, col = "orange", pch = 1, add = TRUE)
legend("bottomright",
   legend = c("mid", "mean", "median"),
   col = c("red", "green", "orange"),
   pch = c(16, 2, 1),
   xpd = NA
)

}

# Polygon centroids:
coastMean <- centroids(coast4, fail = FALSE)
coastMedian <- centroids(coast4, method = "median", fail = FALSE)
coastBMedian <- centroids(coast4, method = "bmedian", fail = FALSE)

if (!is.null(coastMean)) {

plot(coast4)
plot(coastMean, col = "red", add = TRUE)
plot(coastMedian, col = "green", pch = 2, add = TRUE)
plot(coastBMedian, col = "orange", pch = 1, add = TRUE)
legend("bottomright",
   legend = c("mean", "median", "bmedian"),
   col = c("red", "green", "orange"),
   pch = c(16, 2, 1),
   xpd = NA
)

}

}
}
\seealso{
\code{\link[terra:centroids]{terra::centroids()}}; \strong{GRASS} addon module \code{v.centerpoint}.
}
