% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maskNA.r
\name{maskNA,GRaster-method}
\alias{maskNA,GRaster-method}
\alias{maskNA}
\title{Mask all non-NA cells or all NA cells}
\usage{
\S4method{maskNA}{GRaster}(x, value = 1, invert = FALSE, retain = FALSE)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{value}{Numeric: Value to which to assign to masked cells. The default is 1.}

\item{invert}{Logical: If \code{FALSE} (default), convert non-\code{NA} cells to \code{value}, and leave \code{NA} cells as-is. If \code{TRUE}, convert all \code{NA} cells to \code{value}, and non-\code{NA} cells to \code{NA}.}

\item{retain}{Logical: If \code{invert} is \code{TRUE} and \code{retain} is \code{FALSE} (default), non-\code{NA} cells will retain their value. This argument is ignored if \code{invert} is \code{FALSE}.}
}
\value{
A \code{GRaster}.
}
\description{
This function converts all non-\code{NA} cells in a \code{GRaster} to a single user-defined value, leaving \code{NA} cells as \code{NA}. Alternatively, it can convert \code{NA} cells to a user-defined value, and all non-\code{NA} cells to \code{NA.}
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

# Convert non-NA to 1, NA cells remain NA
elevMask <- maskNA(elev)
elevMask
plot(c(elev, elevMask))

# Convert NA to 1, non-NA cells become NA
elevInvertMask <- maskNA(elev, invert = TRUE)
elevInvertMask
plot(c(elev, elevInvertMask))

# Convert NA to 200, non-NA cells keep their values
elevInvertRetain <- maskNA(elev, value = 200, invert = TRUE, retain = TRUE)
elevInvertRetain
plot(c(elev, elevInvertRetain))

}
}
\seealso{
\code{\link[=not.na]{not.na()}}, \code{\link[=app]{app()}}, \code{\link[=mask]{mask()}}
}
