% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoped_na_if.r
\name{scoped_na_if}
\alias{scoped_na_if}
\alias{na_if_all}
\alias{na_if_not_all}
\alias{na_if_at}
\alias{na_if_not_at}
\alias{na_if_if}
\alias{na_if_not_if}
\title{Convert values to NA in multiple columns}
\usage{
na_if_all(.tbl, ...)

na_if_not_all(.tbl, ...)

na_if_at(.tbl, .vars, ...)

na_if_not_at(.tbl, .vars, ...)

na_if_if(.tbl, .predicate, ...)

na_if_not_if(.tbl, .predicate, ...)
}
\arguments{
\item{.tbl}{A \code{tbl} object}

\item{...}{Values to replace with \code{NA}, specified as either:
\itemize{
\item An object, vector of objects, or list of objects
\item A one-sided formula (see section "Formulas" in \code{\link[=na_if]{na_if()}})
}}

\item{.vars}{A list of columns generated by \code{\link[dplyr:vars]{dplyr::vars()}}, a character
vector of column names, a numeric vector of column positions, or NULL.}

\item{.predicate}{A predicate function to be applied to the columns or a
logical vector. The variables for which .predicate is or returns TRUE are
selected. This argument is passed to \code{\link[rlang:as_function]{rlang::as_function()}} and thus
supports quosure-style lambda functions and strings representing function
names.}
}
\value{
A modified data frame. Matched values in selected columns are
replaced with \code{NA}.
}
\description{
\lifecycle{deprecated}
}
\details{
The \link[dplyr:scoped]{dplyr::scoped} variants of \code{\link[=na_if]{na_if()}} and \code{\link[=na_if_not]{na_if_not()}} can be used
directly within pipelines and can modify multiple variables at once.
\itemize{
\item \verb{*_all()} affects every variable
\item \verb{*_at()} affects variables selected with a character vector or
\code{\link[dplyr:vars]{dplyr::vars()}}
\item \verb{*_if()} affects variables selected with a predicate function
}
}
\examples{
\dontrun{
df <- data.frame(a = 0:5, b = 5:0, c = as.numeric(0:5), d = letters[1:6])

na_if_all(df, 0)
na_if_not_all(df, 0:3, "c")

na_if_at(df, c("a", "c"), 0)
na_if_not_at(df, c("a", "c"), 0:3)

na_if_if(df, is.integer, 0)
na_if_not_if(df, is.integer, 0:3)
}

}
\seealso{
\code{\link[=na_if_in]{na_if_in()}} and \code{\link[=na_if_not]{na_if_not()}} operate directly on vectors

\code{\link[dplyr:mutate_all]{dplyr::mutate_all()}}, \code{\link[dplyr:mutate_all]{dplyr::mutate_at()}} and \code{\link[dplyr:mutate_all]{dplyr::mutate_if()}} can
apply any function to variables selected in the same way
}
