% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_extract}
\alias{fct_extract}
\title{Extract Substrings from Factor Levels}
\usage{
fct_extract(factor_vec, pattern, capture_group = 0)
}
\arguments{
\item{factor_vec}{A factor vector from which substrings will be extracted.}

\item{pattern}{A regular expression pattern to match.}

\item{capture_group}{An integer specifying which capture group to extract if using capturing groups in the pattern. Default is \code{0}, which extracts the entire match.}
}
\value{
A new factor vector containing the extracted substrings.
}
\description{
Extracts substrings from the levels of a factor vector based on a regular expression pattern and creates a new factor.
}
\examples{
# Example factor vector
factor_vec <- factor(c('item123', 'item456', 'item789'))

# Extract numeric part
fct_extract(factor_vec, pattern = '\\\\d+')

# Extract with capturing group
factor_vec <- factor(c('apple: red', 'banana: yellow', 'cherry: red'))
fct_extract(factor_vec, pattern = '^(\\\\w+):', capture_group = 1)
}
\author{
Kai Guo
}
