% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_pad_levels}
\alias{fct_pad_levels}
\title{Pad Factor Levels with Leading Characters}
\usage{
fct_pad_levels(factor_vec, width, pad_char)
}
\arguments{
\item{factor_vec}{A factor vector whose levels will be padded.}

\item{width}{An integer specifying the desired total width for each level after padding.}

\item{pad_char}{A character string used for padding. Can be of length one or more characters.}
}
\value{
A factor vector with padded levels.
}
\description{
Pads each level of a factor vector with leading characters to reach a specified width.
}
\examples{
# Example factor vector
factor_vec <- factor(c('A', 'B', 'C', 'D'))

# Pad levels to width 4 using '0' as padding character
padded_factor <- fct_pad_levels(factor_vec, width = 4, pad_char = '0')
print(levels(padded_factor))
# Output: "000A" "000B" "000C" "000D"

# Pad levels to width 6 using '\%A' as padding string
padded_factor <- fct_pad_levels(factor_vec, width = 6, pad_char = '\%A')
print(levels(padded_factor))
# Output: "\%\%A\%A" "\%\%A\%B" "\%\%A\%C" "\%\%A\%D"
}
\author{
Kai Guo
}
