% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fregre.fd.r
\name{predict.fregre.fd}
\alias{predict.fregre.fd}
\title{Predict method for functional linear model (fregre.fd class)}
\usage{
\method{predict}{fregre.fd}(
  object,
  new.fdataobj = NULL,
  se.fit = FALSE,
  scale = NULL,
  df = df,
  interval = "none",
  level = 0.95,
  weights = 1,
  pred.var = res.var/weights,
  ...
)
}
\arguments{
\item{object}{\code{fregre.fd} object.}

\item{new.fdataobj}{New functional explanatory data of \code{fdata} class.}

\item{se.fit}{=TRUE (not default) standard error estimates are returned for
each prediction.}

\item{scale}{Scale parameter for std.err. calculation.}

\item{df}{Degrees of freedom for scale.}

\item{interval}{Type of interval calculation.}

\item{level}{Tolerance/confidence level.}

\item{weights}{variance weights for prediction. This can be a numeric vector
or a one-sided model formula. In the latter case, it is interpreted as an
expression evaluated in newdata}

\item{pred.var}{the variance(s) for future observations to be assumed for
prediction intervals. See \code{link{predict.lm}} for more details.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
If \code{se.fit = FALSE}, a vector of predictions of scalar response
is returned or a matrix of predictions and bounds with column names fit,
lwr, and upr if interval is set.
If \code{se.fit =TRUE} a list with the following components is returned: 
\itemize{
\item  \code{fit}{ A vector of predictions or a matrix of predictions and bounds as above} 
\item  \code{se.fit}{ Associated standard error estimates of predictions} 
\item  \code{residual.scale}{ Residual standard deviations} 
\item  \code{df}{ Degrees of freedom for residual}
}
}
\description{
Computes predictions for regression between functional explanatory variables
and scalar response using: basis representation, Principal Components
Analysis, Partial least squares or nonparametric kernel estimation.

Predicts from a fitted \code{fregre.basis} object,see
\code{\link{fregre.basis}} or \code{\link{fregre.basis.cv}}\cr Predicts from
a fitted \code{fregre.pc} object,see \code{\link{fregre.pc}} or
\code{\link{fregre.pc.cv}}\cr Predicts from a fitted \code{fregre.pls}
object,see \code{\link{fregre.pls}} or \code{\link{fregre.pls.cv}}\cr
Predicts from a fitted \code{fregre.np} object, see \code{\link{fregre.np}}
or \code{\link{fregre.np.cv}}.
}
\examples{
\dontrun{
data(tecator)
absorp=tecator$absorp.fdata
ind=1:129
x=absorp[ind,]
y=tecator$y$Fat[ind]
newx=absorp[-ind,]
newy=matrix(tecator$y$Fat[-ind],ncol=1)
## Functional PC regression
res.pc=fregre.pc(x,y,1:6)
pred.pc=predict(res.pc,newx)
# Functional PLS regression
res.pls=fregre.pls(x,y,1:6)
pred.pls=predict(res.pls,newx)
# Functional nonparametric regression
res.np=fregre.np(x,y,Ker=AKer.tri,metric=semimetric.deriv)
pred.np=predict(res.np,newx)
# Functional regression with basis representation
res.basis=fregre.basis.cv(x,y)
pred.basis=predict(res.basis[[1]],newx)
 
dev.new()
plot(pred.pc-newy)
points(pred.pls-newy,col=2,pch=2)
points(pred.np-newy,col=3,pch=3)
points(pred.basis-newy,col=4,pch=4)
sum((pred.pc-newy)^2,na.rm=TRUE)/sum((newy-mean(newy))^2,na.rm=TRUE)
sum((pred.pls-newy)^2,na.rm=TRUE)/sum((newy-mean(newy))^2,na.rm=TRUE)
sum((pred.np-newy)^2,na.rm=TRUE)/sum((newy-mean(newy))^2,na.rm=TRUE)
sum((pred.basis-newy)^2,na.rm=TRUE)/sum((newy-mean(newy))^2,na.rm=TRUE)
}

}
\references{
Cai TT, Hall P. 2006. \emph{Prediction in functional linear
regression}. Annals of Statistics 34: 2159-2179.

Cardot H, Ferraty F, Sarda P. 1999. \emph{Functional linear model}.
Statistics and Probability Letters 45: 11-22.

Ferraty, F. and Vieu, P. (2006). \emph{Nonparametric functional data
analysis.} Springer Series in Statistics, New York.

Hall P, Hosseini-Nasab M. 2006. \emph{On properties of functional principal
components analysis}. Journal of the Royal Statistical Society B 68:
109-126.

Hardle, W. \emph{Applied Nonparametric Regression}. Cambridge University
Press, 1994.

Ramsay, James O., and Silverman, Bernard W. (2006), \emph{ Functional Data
Analysis}, 2nd ed., Springer, New York.

Febrero-Bande, M., Oviedo de la Fuente, M. (2012).  \emph{Statistical
Computing in Functional Data Analysis: The R Package fda.usc.} Journal of
Statistical Software, 51(4), 1-28. \url{http://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as: \code{\link{fregre.basis}},
\code{\link{fregre.basis.cv}}, \code{\link{fregre.np}},
\code{\link{fregre.np.cv}}, \cr \code{\link{fregre.pc}},
\code{\link{fregre.pc.cv}}, \code{\link{fregre.pls}},
\code{\link{fregre.pls.cv}} \cr and \code{\link{summary.fregre.fd}}.\cr
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{regression}
