% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mesh.2D.R
\name{plot.MESH2D}
\alias{plot.MESH2D}
\title{Plot a MESH2D object}
\usage{
\method{plot}{MESH2D}(x, ...)
}
\arguments{
\item{x}{A MESH2D object defining the triangular mesh, as generated by \code{create.Mesh.2D} or \code{refine.Mesh.2D}.}

\item{...}{Arguments representing graphical options to be passed to \link[graphics]{par}.}
}
\description{
Plot a mesh MESH2D object, generated by \code{create.MESH.2D} or \code{refine.MESH.2D}. Circles indicate the mesh nodes.
}
\examples{
## Upload the Meuse data and a domain boundary
data(MeuseData)
data(MeuseBorder)
## Create a triangular mesh with the provided boundary
mesh <- create.MESH.2D(nodes = MeuseData[,c(2,3)], segments = MeuseBorder, order = 1)
## Plot it
plot(mesh)
}

