% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header.R
\name{header}
\alias{header}
\title{Get table header}
\usage{
header(
  dataset,
  table,
  variable,
  stack = FALSE,
  progress = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{dataset}{Character vector indicating one or more datasets. Identification codes should be as recorded
in \url{http://www.ufsm.br/febr/catalog/}. Use \code{dataset = "all"} to download all datasets.}

\item{table}{Character string indicating a table, i.e. the \emph{layer} table, \code{"camada"}, or the \emph{observation}
table, \code{"observacao"}.}

\item{variable}{(optional) Character vector indicating one or more variables. Accepts only general
identification codes, e.g. \code{"ferro"} and \code{"carbono"}. If missing, then a set of standard identification
variables is downloaded. Use \code{variable = "all"} to download all variables. See \sQuote{Details} for
more information.}

\item{stack}{(optional) Logical value indicating if tables from different datasets should be stacked on a
single table for output. Requires \code{standardization = list(units = TRUE)} -- see below. Defaults to
\code{stack = FALSE}, the output being a list of tables.}

\item{progress}{(optional) Logical value indicating if a download progress bar should be displayed.}

\item{verbose}{(optional) Logical value indicating if informative messages should be displayed. Generally
useful to identify datasets with inconsistent data. Please report to \email{febr-forum@googlegroups.com}
if you find any issue.}
}
\value{
A list of data frames or a data frame with table header data (column names and measurement units) on
the chosen variable(s) of the chosen dataset(s).
}
\description{
Download header data (column names and measurement units) from the \emph{layer} ("camada") or \emph{observation}
("observacao") table of one or more datasets contained in the Free Brazilian Repository for Open Soil Data
-- \emph{\strong{febr}}, \url{http://www.ufsm.br/febr}. This is useful to check what are the variables contained in a
dataset before downloading it via \code{\link[febr]{layer}} or \code{\link[febr]{observation}}.
}
\details{
\subsection{Standard identification variables}{
Standard identification variables and their content depend on the chosen \code{table}. See documentation of
\code{\link[febr]{layer}} and \code{\link[febr]{observation}}.
}
}
\examples{
res <- header(dataset = c("ctb0001", "ctb0003"), table = "camada", variable = "ferro", stack = TRUE)
id <- grep("ferro_", colnames(res))
col <- colnames(res)[id]
col[order(col)]
}
\seealso{
\code{\link[febr]{layer}}, \code{\link[febr]{observation}}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
