% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tier.R
\name{build_tier}
\alias{build_tier}
\title{Build settings for a tier}
\usage{
build_tier(
  by.x = NULL,
  by.y = NULL,
  check_merge = NULL,
  match_type = NULL,
  fuzzy_settings = build_fuzzy_settings(),
  score_settings = NULL,
  filter = NULL,
  filter.args = NULL,
  evaluate = NULL,
  evaluate.args = NULL,
  clean_settings = build_clean_settings(),
  clean = NULL,
  allow.cartesian = FALSE,
  multivar_settings = build_multivar_settings()
)
}
\arguments{
\item{by.x}{character string. Variable to merge on in data1. See \code{merge}}

\item{by.y}{character string. Variable to merge on in data2. See \code{merge}}

\item{check_merge}{logical. Checks that your unique_keys are indeed unique.}

\item{match_type}{string. If 'exact', match is exact, if 'fuzzy', match is
fuzzy. If 'multivar,' match is multivar-based. See \code{multivar_match},}

\item{fuzzy_settings}{additional arguments for amatch, to be used if match_type
= 'fuzzy'. Suggested defaults provided. (see amatch, method='jw')}

\item{score_settings}{list. Score settings for post-hoc matchscores.}

\item{filter}{function or numeric. Filters a merged data1-data2 dataset. If a
function, should take in a data.frame (data1 and data2 merged by name1 and
name2) and spit out a trimmed verion of the data.frame (fewer rows). Think
of this function as applying other conditions to matches, other than a
match by name. The first argument of filter should be the data.frame. If
numeric, will drop all observations with a matchscore lower than or equal
to filter.}

\item{filter.args}{list. Arguments passed to filter, if a function}

\item{evaluate}{Function to evalute merge_plus output.}

\item{evaluate.args}{ist. Arguments passed to evaluate}

\item{clean_settings}{list. Arguments passed to clean.}

\item{clean}{Function to clean strings prior to match. see \code{clean_strings}.}

\item{allow.cartesian}{whether or not to allow many-many matches, see data.table::merge()}

\item{multivar_settings}{list of settings to go to the multivar match if match_type
== 'multivar'. See \code{multivar-match}.}
}
\value{
a list containing 1 tier for the 'tier_list' argument of \code{tier_match}.
}
\description{
\code{build_tier_settings} is a convenient way to make the proper list for the
\code{tier_list} argument of \code{tier_match} Each vector in build_score_settings
should be the same length, and each position (first, second, third, etc.)
corresponds to one variable to score on.
}
