% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_predictions_test.R
\name{compare_predictions_test}
\alias{compare_predictions_test}
\title{Determine whether the percentage of ties correctly predicted by the FERGM are statistically distinguishable from those of the ERGM}
\usage{
compare_predictions_test(compare_predictions_out = NULL, alpha_level = 0.05)
}
\arguments{
\item{compare_predictions_out}{Matrix of correctly predicted ties produced by the compare_predictions function.}

\item{alpha_level}{The significance level that should be used for the test.}
}
\value{
Returns a ks.test output to determine if the ERGM predictions are less than the FERGM predictions and prints a message to assist with interpretation
}
\description{
This is a plot function to determine whether the distributions of predictions from ERGM and FERGM objects differ.
}
\examples{
# load example data
data("ergm.fit")
data("fergm.fit")
data("mesa")
# Use built in compare_predictions function to compare predictions of ERGM and FERGM,
# few replications due to example
predict_out <- compare_predictions(ergm_fit = ergm.fit, fergm_fit = fergm.fit,
                                   replications = 10)

# We can also conduct a KS test to determine if the FERGM fit it statistically
 # distinguishable from the ERGM fit
compare_predictions_test(predict_out)
}
\keyword{Fit}
\keyword{GOF}
\keyword{KS}
\keyword{Kolmogorov-Smirnov}
\keyword{Prediction}
\keyword{Test}
