% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_detectEWMAMeanSingle}
\alias{cpp_detectEWMAMeanSingle}
\title{Find the first changepoint in the mean using EWMA}
\usage{
cpp_detectEWMAMeanSingle(x, r, L, BL)
}
\arguments{
\item{x}{Vector of numeric values values.}

\item{r}{control parameter for EWMA. Must be in range \eqn{[0,1]}.}

\item{L}{control parameter for EWMA.}

\item{BL}{Value for the burn-in length.}
}
\value{
A list with 
\describe{
            \item{\code{tauhat}}{A vector of the changepoints found.}
         }
}
\description{
Given a vector \code{x}, control parameters \code{r} and \code{L},
and a burn-in length \code{BL}, returns a list containing the changepoints.
Algorithm is implemented in 'C++'.
}
\details{
'EWMA' updates via: 
         \deqn{Z_{j} = (1-r) Z_{j-1} + r x_{j}}
         where \eqn{\mu} is the mean of the in-control stream, 
         \eqn{x_j} is the observation at time \eqn{j} and \eqn{r} 
         is a control parameter for EWMA. Then, a change is signalled
         if \deqn{|Z_j - \mu|  > L \sigma_{Z_j}}, 
         where \eqn{L} is the other control parameter, and 
         \eqn{\sigma_{Z_j}} is a scaled version of the in-control
         variance \eqn{\sigma}.
         This is the formulation for using 'EWMA' to detect an increase or
         decrease in the mean.
}
\keyword{internal}
