# fhircrackr 1.0.0
The package is now rewritten using S4 classes. Almost all of the code written with fhircrackr < 1.0.0 will still work, though in a few cases the user will be prompted to change their code to the new syntax.

The most prominent change is how to create a `design` that tells `fhir_crack()` how to flatten HL7 FHIR® Resources. It should now be created using the functions `fhir_table_description()` and `fhir_design()`. `fhir_crack()` is now also able to create a single data.frame/data.table instead of a list of tables when just one resource type is extracted. Please see the documentation under `?fhir_table_description` and `?fhir_design`! 

To get an overview about how the general workflow has changed, please have a look at the intro vignette (`vignette("fhircrackr_intro", package="fhircrackr")`).

There are a couple of new constructor functions for the newly defined classes which will not be listed here. Please have look at the package vignettes which go through them in detail. 

Other new functions or behavior are listed in the following:

## New functions
- `fhir_authenticate()`: Set up authentication using OAuth2/OpenID Connect
- `fhir_current_request()`: Get search request used in most recent call to `fhir_search()`or `fhir_url()`
- `fhir_extract_indices()`: Extract indices from a table with multiple entries
- `fhir_restore_indices()`: Restore removed indices in a table with multiple entries
- `fhir_melt_all()`: Melt all multiple entries in a table.


## New behavior
- `fhir_search()` now allows for a search via POST via the argument `body`.

- `fhir_search()` can now handle bearer token authentication via the argument `token`.

- Argument `save_to_file` in `fhir_search()` now takes `NULL` or a string with a directory name and saves the bundles only if there is a specified directory. For backwards compatibility `TRUE`/`FALSE` in combination with `directory` are still allowed but discouraged with a warning.

- Argument `log_errors` in `fhir_search()` now takes a string with a filename and writes an xml (no tables anymore) to the specified file. For backwards compatibility numbers are still allowed but discouraged with a warning. 

- New argument `delay_between_bundles` for `fhir_search()` allows to put a delay between the download of bundles (i.e. pages) in a bigger search request to prevent weak servers from choking.

- The output of `fhir_capability_statement()` is slightly restructured.

- The deprecated argument `add_indices` in `fhir_crack()` is now fully removed.

- The most recently used FHIR search request is now implicitly saved whenever `fhir_search()` or `fhir_url()` is called. It can be accessed with the new function `fhir_current_request()`.





# fhircrackr 0.2.1

- fhir_melt now gives a warning when the brackets provided in the function call don't appear in the data frame 

- A number of bugs have been fixed 

	- unintended type changes from data.frame to data.table are now prevented
	- `fhir_melt()` now takes the name provided in the argument `id_name` (which because of a bug it didn't before)
	- inconsistencies in assignment of default values to the design for `fhir_crack()` have been cleared
	- fixed bug causing column names to disappear when `cols` element of design was of length one
	
	


# fhircrackr 0.2.0

- design for `fhir_crack()` has new form now:

   1. has now named elements `resource`, `cols`, `style` (with style elements `sep`, `brackets`, `rm_empty_cols`)

   2. old versions of design still work

- new function `fhir_canonical_design()` returns the full (potentially automatically completed) design of the most recent call to `fhir_crack()`

- argument `add_indices` of `fhir_crack()` is now deprecated, indices will be added when `brackets` is not NULL

- new argument `columns` of `fhir_rm_indices()` gives control over the columns in which indices should be removed

- new functions `fhir_save_design()` and `fhir_load_design()` for saving/loading design as xml-document

- new function `fhir_next_bundle_url()` returns next-link of the last bundle processed by the most recent call to `fhir_search()`

- new arguments `save_to_disc` and `directory` of `fhir_search()` allow for saving bundles consecutively as xml files instead of loading them into the R session all at once

- Faster results of `fhir_crack()` because it now uses data.table internally

- new argument `data.table` of `fhir_crack` to choose between data.frame vs. data.table as output format


# fhircrackr 0.1.1

- fixed errors in `fhir_crack()` when resource type doesn't appear in bundle

- handle errors caused by the accidental use of serialized objects more gracefully

- `@value` at the end of an XPath expression pointing to an attribute for `design` used in `fhir_crack()` is now optional and will be added automatically by fhir_crack if omitted

- column names automatically generated by `fhir_crack()` are now shorter.



# fhircrackr 0.1.0

First Release of R-Package fhirckrackr v0.1.0
