# fieldRS
[![CRAN version](https://www.r-pkg.org/badges/version/fieldRS)](https://CRAN.R-project.org/package=fieldRS)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/last-month/fieldRS?color=brightgreen)](https://CRAN.R-project.org/package=fieldRS)
[![CRAN downloads](http://cranlogs.r-pkg.org/badges/grand-total/fieldRS?color=brightgreen)](https://CRAN.R-project.org/package=fieldRS)

<p align="justify" style="line-height:200%;">
fieldRS is an R package to support Remote Sensing oriented field work. It was developed at the Department of Remote Sensing of the University of Würzburg, Germany, within the Central Asia Waters (<a href="http://www.cawa-project.net/">CAWa</a>) project funded by the <a href="https://www.auswaertiges-amt.de/en">German Federal Foreign Office</a>. It is part of the German Water Initiative for Central Asia (the so-called <a href="http://waterca.org/en/the-berlin-process/">Berlin process</a>), launched by the German Federal Foreign Office launched on the 1<sup>st</sup> of April of 2008 to support peaceful, sustainable and mutually beneficial management of transboundary water resources in Central Asia.
</p>
<p align="justify" style="line-height:200%;">
fieldRS was designed to ease the collection and management of ground truth data. It provides tools that help select sampling sites, correct and pre-process training data and preview classification results in order to identify potentially incorrect samples. The package provides a tutorial (found <a href="https://CRAN.R-project.org/package=fieldRS/vignettes/fieldRS.html">here</a>) which contains a detailed methodology based on the package. It guides potential users in the full process of designing a remote sensing field campaign from the selection of potential study sites to the development predictive models. At the moment, fieldRS is oriented towards land cover mapping but will be 
</p>

</br>

### What else are we doing?
<p align="justify" style="line-height:200%;">
The Department of Remote Sensing of the University of Würzburg has developed other R packages that might interest you:
</p>

* <a href="https://bleutner.github.io/RStoolbox/">RStoolbox</a>
* <a href="https://github.com/cran/moveVis/">moveVis</a>
* <a href="https://github.com/RRemelgado/rsMove">fieldRS</a>
* <a href="https://github.com/RRemelgado/CAWaR">CAWaR</a>

<p align="justify" style="line-height:200%;">
Click <a href="http://remote-sensing.eu/">here</a> for news on our department.
</p>

</br>

## Supported by
<p>
<a href="https://www.orn.mpg.de/en/"><img width="250" height="50" src="https://www.gfz-potsdam.de/fileadmin/_processed_/0/8/csm_CAWa_Logo_ae5c278929.png"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.geographie.uni-wuerzburg.de/en/fernerkundung/startseite/"><img width="130" height="80" src="https://www.uni-wuerzburg.de/typo3conf/ext/uw_sitepackage/Resources/Public/Images/uni-wuerzburg-logo.svg"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.dlr.de/eoc/en/desktopdefault.aspx/tabid-5278/8856_read-15911/"><img width="115" height="100" src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/f5/DLR_Logo.svg/744px-DLR_Logo.svg.png"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.auswaertiges-amt.de/en/"><img width="190" height="70" src="https://www.ifa.de/fileadmin/content/logos/A/aa_englisch.jpg"></a>
</p>
</br>
