% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{parse_response_object}
\alias{parse_response_object}
\title{Parse the response data and fit it into a R object}
\usage{
parse_response_object(response, .output_format, ...)
}
\arguments{
\item{response}{The \code{response} object returned by the \code{httr} HTTP
methods (e.g. \code{httr::GET()});}

\item{.output_format}{A string with the name of the output format chosen by the user;}

\item{...}{Further arguments passed by the caller;}
}
\description{
This function is usually called by \code{get_figma_file()},
\code{get_document_info()} and \code{get_figma_page()}, to process
the \code{response} object returned by the \code{httr} HTTP methods, such as
\code{httr::GET()}.
}
\details{
The functions from \code{figma} package adopts the philosophy to give, by
default, the most raw and unprocessed result possible to the user. Because
of it, \code{parse_response_object()} is usually called with
\code{.output_format = "response"}, which makes the function to just
return the input as is.

This unprocessed and raw input gives all of the possible information to
the user (which is good for debugging). But this information is usually in
a very messy and not friendly format, which makes harder for data analysis
and transformation pipelines.

The \code{.output_format} argument provide an option for the user to choose
a more friendly format. As an example, with \code{.output_format = "tibble"},
\code{parse_response_object()} will call \code{figma::as_tibble()} to
parse the data of the \code{response} object, and fit it into a
\code{tibble::tibble()} object.
}
