% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humann2meco.R
\name{humann2meco}
\alias{humann2meco}
\title{Transform 'HUMAnN' metagenomic results to 'microtable' object.}
\usage{
humann2meco(
  feature_table,
  db = c("MetaCyc", "KEGG", "gene")[1],
  sample_table = NULL,
  match_table = NULL,
  ...
)
}
\arguments{
\item{feature_table}{file path of 'HUMAnN' output abundance table; Please see the example.}

\item{db}{default "MetaCyc"; one of "MetaCyc", "KEGG" or "gene"; "MetaCyc" or "KEGG" means the input feature table is pathway abundance.
"gene" represents the abundance of genes, such as 'eggNOG', 'KO' and 'EC'. 
When using "gene", the generated tax_table has only taxonomic lineages and gene name, no higher functional levels.}

\item{sample_table}{default NULL; sample metadata table; If provided, must be one of the several types of formats: \cr
1) comma seperated file with the suffix csv or tab seperated file with suffix tsv or txt; \cr
2) Excel type file with the suffix xlsx or xls; require \code{readxl} package to be installed; \cr
3) \code{data.frame} object from R.}

\item{match_table}{default NULL; a two column table used to replace the sample names in feature table; Must be two columns without column names;
The first column must be raw sample names same with those in feature table, 
the second column must be new sample names same with the rownames in sample_table; Please also see the example files.
If provided, must be one of the several types of formats: \cr
1) comma seperated file with the suffix csv or tab seperated file with suffix tsv/txt; \cr
2) Excel type file with the suffix xlsx or xls; require \code{readxl} package to be installed; \cr
3) \code{data.frame} object from R.}

\item{...}{parameter passed to \code{microtable$new} function of \code{microeco} package, such as \code{auto_tidy} parameter.}
}
\value{
\code{microtable} object.
}
\description{
Transform 'HUMAnN' metagenomic results to microtable object, reference: Franzosa et al. (2018) <doi:10.1038/s41592-018-0176-y>.
}
\examples{
\donttest{
library(file2meco)
library(microeco)
library(magrittr)
sample_file_path <- system.file("extdata", "example_metagenome_sample_info.tsv", 
  package="file2meco")
match_file_path <- system.file("extdata", "example_metagenome_match_table.tsv", package="file2meco")
# MetaCyc pathway examples
# use the raw data files stored inside the package for MetaCyc pathway database based analysis
abund_file_path <- system.file("extdata", "example_HUMAnN_MetaCyc_abund.tsv", package="file2meco")
# the default db is "MetaCyc"
humann2meco(abund_file_path, db = "MetaCyc")
humann2meco(abund_file_path, db = "MetaCyc", sample_table = sample_file_path, 
  match_table = match_file_path)
test <- humann2meco(abund_file_path, db = "MetaCyc", sample_table = sample_file_path, 
  match_table = match_file_path)
test$tidy_dataset()
# rel = FALSE sum original abundance instead of relative abundance
test$cal_abund(select_cols = 1:3, rel = FALSE)
test$taxa_abund$Superclass1 \%<>\% .[!grepl("unclass", rownames(.)), ]
# use_percentage = FALSE disable percentage for relative abundance
test1 <- trans_abund$new(test, taxrank = "Superclass1", ntaxa = 10, use_percentage = FALSE)
# reassign ylab title instead of default 'Relative Abundance'
test1$ylabname <- "Abundance (RPK)"
# bar_type = "notfull" show original abundance instead of normalized 0-1
test1$plot_bar(facet = "Group", bar_type = "notfull")
# select both function and taxa
test$cal_abund(select_cols = c("Superclass1", "Phylum", "Genus"), rel = TRUE)
test1 <- trans_abund$new(test, taxrank = "Phylum", ntaxa = 10, delete_taxonomy_lineage = TRUE)
test1$plot_bar(facet = "Group")
test$taxa_abund$Phylum \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_abund$new(test, taxrank = "Phylum", ntaxa = 10, delete_taxonomy_lineage = FALSE)
test1$plot_bar(facet = "Group")
# functional biomarker
test$cal_abund(select_cols = 1:3, rel = TRUE)
test$taxa_abund$Superclass1 \%<>\% .[!grepl("unclass", rownames(.)), ]
test$taxa_abund$Superclass2 \%<>\% .[!grepl("unclass", rownames(.)), ]
test$taxa_abund$pathway \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_diff$new(test, method = "lefse", group = "Group")
test1$plot_diff_bar(use_number = 1:20)
# taxa biomarker
test$cal_abund(select_cols = 4:9, rel = TRUE)
test$taxa_abund$Phylum \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_diff$new(test, method = "lefse", group = "Group", p_adjust_method = "none")
test1$plot_diff_bar(threshold = 2)
#############################################################
# KEGG pathway examples
abund_file_path <- system.file("extdata", "example_HUMAnN_KEGG_abund.tsv", package="file2meco")
humann2meco(abund_file_path, db = "KEGG")
test <- humann2meco(abund_file_path, db = "KEGG", 
  sample_table = sample_file_path, match_table = match_file_path)
test$tax_table \%<>\% subset(Level.1 != "unclassified")
test$tidy_dataset()
test$cal_abund(select_cols = 1:3, rel = FALSE)
# use_percentage = FALSE disable percentage for relative abundance
test1 <- trans_abund$new(test, taxrank = "Level.2", ntaxa = 10, use_percentage = FALSE)
# or use ggplot2::ylab to change ylab title
test1$ylabname <- "Abundance (RPK)"
test1$plot_bar(facet = "Group", bar_type = "notfull")
# select both function and taxa
test$cal_abund(select_cols = c("Level.1", "Phylum", "Genus"), rel = TRUE)
test1 <- trans_abund$new(test, taxrank = "Phylum", ntaxa = 10, delete_taxonomy_lineage = FALSE)
test1$plot_bar(facet = "Group")
# functional biomarker
test$cal_abund(select_cols = 1:3, rel = TRUE)
test1 <- trans_diff$new(test, method = "lefse", group = "Group")
test1$plot_diff_bar(threshold = 3)
# taxa biomarker
test$cal_abund(select_cols = 4:9, rel = TRUE)
test1 <- trans_diff$new(test, method = "lefse", group = "Group", p_adjust_method = "none")
test1$plot_diff_bar(threshold = 2)
}
}
