% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tekno.R
\name{read_tekno}
\alias{read_tekno}
\title{Read a Teknologic Acoustic Receiver File}
\usage{
read_tekno(path, file, timezone = "America/Los_Angeles")
}
\arguments{
\item{path}{the path to the folder containing the desired file}

\item{file}{the path of the desired file}

\item{timezone}{the Olsen Named time zone, default is "America/Los_Angeles"}
}
\value{
A dataframe converting the raw detection data into rows of detections
}
\description{
This function takes a raw acoustic detection file generated by a Teknologic
JSATS receiver and processes it into a dataframe which can be used by
the filtering functions in this package. This is called within read_jsats().
}
\examples{
# Read in a Teknologic file
path = system.file("extdata/", package = "filteRjsats")
read_tekno(path = path, file = "2015-6007211361217.SUM",
timezone = "America/Los_Angeles")
}
